# migrant_lib

[![Build Status](https://travis-ci.org/jaemk/migrant_lib.svg?branch=master)](https://travis-ci.org/jaemk/migrant_lib)
[![crates.io:migrant_lib](https://img.shields.io/crates/v/migrant_lib.svg?label=migrant_lib)](https://crates.io/crates/migrant_lib)
[![docs](https://docs.rs/migrant_lib/badge.svg)](https://docs.rs/migrant_lib)

> Embeddable migration management
>
> Also see [`migrant`](https://github.com/jaemk/migrant) CLI

`migrant_lib` allows defining and embedding management of database migrations and
(connection) configuration in your compiled application.


**Available Features:**

| Feature       |    Backend                   |
|---------------|------------------------------|
| `d-postgres`  | Enable postgres connectivity |
| `d-sqlite`    | Enable sqlite connectivity   |
| `d-mysql`     | Enable mysql connectivity    |
| `d-all`       | Enable all backends          |


*Notes:*

- No features are enabled by default
- As of `0.20.0` the `d-sqlite` feature does not use `rusqlite`s `bundled` feature.
  If you would like `sqlite` to be bundled with your application, you will have to
  include `rusqlite` and enable the `bundled` feature in your project.


## Usage

- Migrations can be defined as files, string literals, or functions.
- File migrations can be either read from files at runtime or embedded in your executable at compile time
  (using [`include_str!`](https://doc.rust-lang.org/std/macro.include_str.html)).
- Migration tags must all be unique and may only contain the characters `[a-z0-9-]`.
  When running in a `cli_compatible` mode (see `Config::use_cli_compatible_tags`), tags must also be
  prefixed with a timestamp, following: `[0-9]{14}_[a-z0-9-]+`.
  See the [embedded_cli_compatible](https://github.com/jaemk/migrant_lib/blob/master/examples/embedded_cli_compatible.rs)
  example.
- Function migrations must have the signature `fn(ConnConfig) -> Result<(), Box<dyn std::error::Error>>`.
  See the [embedded_programmable](https://github.com/jaemk/migrant_lib/blob/master/examples/embedded_programmable.rs)
  example for a working sample of function migrations.
- When working with embedded and function migrations, the respective database feature must be
  enabled (`d-postgres` / `d-sqlite` / `d-mysql`).
- When `d-postgres` is enabled, you can specify a custom/self-signed ssl certificate using
  `PostgresSettingsBuilder::ssl_cert_file` or setting `ssl_cert_file = "..."` in your `Migrant.toml`.


```rust
fn up(_: migrant_lib::ConnConfig) -> Result<(), Box<dyn std::error::Error>> {
    print!(" Up!");
    Ok(())
}

fn down(_: migrant_lib::ConnConfig) -> Result<(), Box<dyn std::error::Error>> {
    print!(" Down!");
    Ok(())
}

config.use_migrations(&[
    migrant_lib::FileMigration::with_tag("create-users-table")
        .up("migrations/embedded/create_users_table/up.sql")?
        .down("migrations/embedded/create_users_table/down.sql")?
        .boxed(),
    migrant_lib::EmbeddedMigration::with_tag("create-places-table")
        .up(include_str!("../migrations/embedded/create_places_table/up.sql"))
        .down(include_str!("../migrations/embedded/create_places_table/down.sql"))
        .boxed(),
    migrant_lib::FnMigration::with_tag("custom")
        .up(up)
        .down(down)
        .boxed(),
])?;
```


## CLI Compatibility

Migration management identical to the [`migrant`](https://github.com/jaemk/migrant) CLI tool can also be embedded.
This method only supports file-based migrations (so `FileMigration`s or `EmbeddedMigration`s using `include_str!`)
and those migration files names must be timestamped with the format `[0-9]{14}_[a-z0-9-]+`,
Properly named files can be generated by `migrant_lib::new` or the `migrant` CLI tool.
This is required because migration order is implied by file names which must follow
a specific format and contain a valid timestamp.

See the [migrant_cli_compatible](https://github.com/jaemk/migrant_lib/blob/master/examples/migrant_cli_compatible.rs)
example for a working sample where migration files and a `Migrant.toml` config file are available at runtime.

See the [embedded_cli_compatible](https://github.com/jaemk/migrant_lib/blob/master/examples/embedded_cli_compatible.rs)
example for a working sample where the `migrant` CLI tool can be used during development, and database configuration
and migration file contents are embedded in the application.


## Development

See [CONTRIBUTING](https://github.com/jaemk/migrant_lib/blob/master/CONTRIBUTING.md)

----


License: MIT
