# Miden verifier
This crate contains a light-weight verifier which can be used to verify proofs of program execution generated by Miden VM.

While [Miden](../miden) crate also contains verifier functionality, if a project needs only to verify proofs generated by Miden VM, this crete may be more appropriate to rely on.

## Usage
This crate exposes a `verify()` function which can be used to verify proofs of program execution. The function takes the following parameters:

* `program_hash: &[u8; 32]` - an array of 32 bytes representing a hash of the program to be verified.
* `public_inputs: &[u128]` - a list of public inputs against which the program was executed.
* `outputs: &[u128]` - a list of outputs generated by the program.
* `proof: &StarkProof` - the proof generated during program execution.

The function returns `Result<(), VerifierError>` which will be `Ok(())` if verification passes, or `Err(VerifierError)` if verification fails, with `VerifierError` describing the reason for the failure.

Verifying execution proof of a program basically means the following:

> If a program with the provided hash is executed against some secret inputs and the provided public inputs, it will produce the provided outputs.

Notice how the verifier needs to know only the hash of the program - not what the actual program was.

## License
This project is [MIT licensed](../LICENSE).