# Compilation from Source

This sections details how to compile libmicrovmi from source.

You might want to dive into it if you are interested by:

- compiling a specific driver that is not available by default in the officially distributed version
- developing libmicrovmi
  - add a new driver
  - extend the APIs

We assume that you have a working Cargo stable toolchain.

⚠️ Note: each driver depends on development headers to be install in order
to generate the bindings from C to Rust.

For any driver, `clang` is a required dependency:
~~~
$ sudo apt-get install clang
~~~

Please look at the [driver reference](https://wenzel.github.io/libmicrovmi/reference/drivers.html) section of the documentation.

## Cloning libmicrovmi

Clone the [repo](https://github.com/Wenzel/libmicrovmi):

~~~
$ git clone https://github.com/Wenzel/libmicrovmi
~~~

## Rust

Compilation for a Rust crate is as simple as using cargo:

~~~
$ cargo build --features xen,kvm
~~~

## C

The C library is generated by default when building the microvmi crate.

The output files will be located at:
`target/<debug|release>/libmicrovmi.so` : the C library
`target/<debug|release>/capi/libmicrovmi.h` : the development header

## Python

To build the native Python extension, create a virtualenv and run `./setup.py`:

~~~
$ cd libmicrovmi/python
$ python3 -m venv venv
$ source venv/bin/activate
(venv) $ python -m pip install --upgrade setuptools
(venv) $ python -m pip install -r requirements.txt
(venv) $ ./setup.py install --features xen,kvm
~~~

Note:
- `./setup.py install` : will create a release build
- `./setup.py develop` : will create a debug build
- `pip install .` is **NOT** available due a to an issue in [setuptools-rust/Maturin](https://github.com/PyO3/maturin/issues/330). Do not use `pip`.