# VMI Fragmentation

_Virtual Machine Introspection_ has been around since [2003](https://www.ndss-symposium.org/ndss2003/virtual-machine-introspection-based-architecture-intrusion-detection/),
yet the ecosystem is still heavily fragmented and lacks standards as well as interoperability.

See our talk at FOSDEM 2020: [Rustifying the Virtual Machine Introspection ecosystem](https://archive.fosdem.org/2020/schedule/event/rust_vm_introspection/).

## Debugging

- [pyvmidbg](https://github.com/Wenzel/pyvmidbg)
- [icebox](https://github.com/thalium/icebox)
- [rVMI](https://github.com/fireeye/rvmi)

## Live Memory Forensics

- [LiveCloudKd](https://github.com/comaeio/LiveCloudKd)
- [volatility](https://github.com/volatilityfoundation/volatility)
- [volatility3](https://github.com/volatilityfoundation/volatility3/)
- [rekall](https://github.com/google/rekall)
- [MemProcFS](https://github.com/ufrisk/MemProcFS)

## Dynamic Analysis

- [DRAKVUF](https://github.com/tklengyel/drakvuf)
- [PyREBox](https://github.com/Cisco-Talos/pyrebox)
- [PANDA](https://github.com/panda-re/panda)
- [DECAF](https://github.com/decaf-project/DECAF)

## Cloud Monitoring

- [HVMI](https://github.com/hvmi/hvmi)

## Fuzzing

- [applepie](https://github.com/gamozolabs/applepie)
- [Nyx](https://www.usenix.org/conference/usenixsecurity21/presentation/schumilo)

## Libraries

- [LibVMI C library](https://github.com/libvmi/libvmi)
- [KVM-VMI](https://github.com/KVM-VMI/kvm-vmi/)