pub trait Condition {}

struct Comparison<'val, T: 'val + crate::model::Entity> {
    column: <T as crate::model::Entity>::Column,
    val: &'val dyn rusqlite::ToSql,
}

impl<T: crate::model::Entity> Condition for Comparison<'_, T> {}

pub fn equal<'val, T: 'val + crate::model::Entity>(
    column: <T as crate::model::Entity>::Column,
    val: &'val dyn rusqlite::ToSql,
) -> impl Condition + 'val {
    Comparison::<T> { column, val }
}

struct Conjunction<L: Condition, R: Condition> {
    left: L,
    right: R,
}

pub fn both<L: Condition, R: Condition>(left: L, right: R) -> impl Condition {
    Conjunction { left, right }
}

impl<L: Condition, R: Condition> Condition for Conjunction<L, R> {}
