//! Optimizations on the MIR. Not much going on here, for now.
use super::{Mir, MirEdge, MirGraph, MirNode, Region};

/// A destructive optimization pass. Strips out metadata collection,
/// for program users that don't need information about intermediate results.
pub fn destroy_metadata(mir: &mut Mir) {
    destroy_metadata_inner(&mut mir.graph);
}

fn destroy_metadata_inner(graph: &mut MirGraph) {
    // We just destroy all the IntermediateResultEdges, and that prevents
    // any Fmt nodes from showing up in the DfsPostOrder walk when we lower it.
    // We don't delete nodes, because that would affect node numbering.
    let new = graph.filter_map(
        |_idx, node| match node {
            MirNode::Loop(region, ty) => {
                let mut new = region.graph.clone();
                destroy_metadata_inner(&mut new);
                Some(MirNode::Loop(
                    Region {
                        graph: new,
                        end: region.end,
                    },
                    ty.clone(),
                ))
            }
            MirNode::FunctionDefinition(region) => {
                let mut new = region.graph.clone();
                destroy_metadata_inner(&mut new);
                Some(MirNode::FunctionDefinition(Region {
                    graph: new,
                    end: region.end,
                }))
            }
            node => Some(node.clone()),
        },
        |_idx, edge| match edge {
            MirEdge::IntermediateResultDependency { port: _ } => None,
            edge => Some(edge.clone()),
        },
    );
    *graph = new;
}
