class ApiClient {
  constructor() {}

  async findAll<T>(collection: string): Promise<BaseEntity<T>[]> {
    const response = await fetch(`/api/${collection}`)
    if (response.ok) {
      const { data } = await response.json()
      return data
    }
    return []
  }

  async create<T>(collection: string, body: T): Promise<T> {
    const response = await fetch(`/api/${collection}`, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify(body),
    })
    const { data } = await response.json()
    return data
  }

  async delete(collection: string, id: string): Promise<{ deleted: number }> {
    const response = await fetch(`/api/${collection}/${id}`, {
      method: 'DELETE',
      headers: {
        'Content-Type': 'application/json',
      },
    })
    const { data } = await response.json()
    return data
  }

  async update<T>(
    collection: string,
    id: string,
    entity: T
  ): Promise<{ deleted: number }> {
    const response = await fetch(`/api/${collection}/${id}`, {
      method: 'PUT',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify(entity),
    })
    const { data } = await response.json()
    return data
  }
}

export default new ApiClient()
