mod helpers;

use anyhow::Result;
use handlebars::Handlebars;

use crate::embedded::{Pages, Parts};
use helpers::*;

pub fn init_handlebars() -> Result<Handlebars<'static>> {
    let mut hb = Handlebars::new();

    // Register helpers
    hb.register_helper("json", Box::new(json_helper));
    hb.register_helper("title", Box::new(title_helper));
    hb.register_helper("form_field", Box::new(form_field_helper));
    hb.register_helper("field_value", Box::new(field_value_helper));
    hb.register_helper("title_field", Box::new(title_field_helper));

    // Register parts
    for path in Parts::iter() {
        let name = path.to_string().replace(".hbs", "");
        if let Some(file) = Parts::get(&path) {
            let raw = String::from_utf8(file.data.to_vec())?;
            hb.register_partial(&name, raw)?;
        }
    }

    // Register pages
    for path in Pages::iter() {
        let name = path.to_string().replace(".hbs", "");
        if let Some(file) = Pages::get(&path) {
            let raw = String::from_utf8(file.data.to_vec())?;
            hb.register_template_string(&name, &raw)?;
        }
    }

    Ok(hb)
}
