use actix_web::{HttpResponse, Responder};
use serde_json::json;
use std::sync::Arc;

use crate::server::AppContext;

pub fn render_page(
    name: &str,
    context: Arc<AppContext>,
    data: serde_json::Value,
) -> impl Responder {
    let html = context
        .hb
        .render(
            name,
            &json!({
                "context": &data,
                "project": context.project,
                "models": context.project.models,
            }),
        )
        .unwrap();

    HttpResponse::Ok()
        .body(html)
        .with_header("Content-Type", "text/html")
}
