use actix_web::{get, web, Responder};
use serde_json::json;
use std::sync::Arc;

use crate::{
    api::ApiResult,
    server::{
        utils::{model::get_model, render::render_page},
        AppContext,
    },
};

#[get("/models/{model_name}/{entity_id}")]
pub async fn entity_view(
    web::Path((model_name, entity_id)): web::Path<(String, String)>,
    context: web::Data<AppContext>,
) -> impl Responder {
    let model = get_model(Arc::clone(&context), model_name.clone());
    if let Ok(ApiResult::Data(entity)) = context.client.find_by_id(&model_name, &entity_id).await {
        render_page(
            "entity",
            Arc::clone(&context),
            json!({ "entity": entity, "model": model }),
        )
    } else {
        render_page("404", Arc::clone(&context), json!({"thing": "entity"}))
    }
}

#[get("/models/{model_name}/new")]
pub async fn create_entity_view(
    web::Path(model_name): web::Path<String>,
    context: web::Data<AppContext>,
) -> impl Responder {
    let model = get_model(Arc::clone(&context), model_name);

    render_page(
        "create_entity",
        Arc::clone(&context),
        json!({ "model": model }),
    )
}
