declare const PROJECT: Project
declare const CONTEXT: Context
declare const feather: { replace(): void }

interface Project {
  name: string
  version: string
}

interface Context {
  model?: Model
  entities?: any[]
}

interface Model {
  name: string
  fields: Field[]
}

type Field = {
  name: string
  type: 'image' | 'reference' | 'text' | 'list'
}

type BaseEntity<T> = {
  _id: { $oid: string }
} & T
