export function html(
  element: keyof HTMLElementTagNameMap,
  options?: {
    text?: string
    classList?: string[]
    children?: HTMLElement[]
  }
) {
  const elem = document.createElement(element)
  elem.textContent = options?.text ?? ''
  options?.classList?.forEach((c) => elem.classList.add(c))
  options?.children?.forEach((child) => elem.appendChild(child))
  return elem
}
