use actix_web::{get, web, Responder};
use serde_json::json;
use std::sync::Arc;

use crate::server::{
    utils::{model::get_model, render::render_page},
    AppContext,
};

#[get("/models/{model_name}/new")]
pub async fn create_entity_view(
    web::Path(model_name): web::Path<String>,
    context: web::Data<AppContext>,
) -> impl Responder {
    let model = get_model(Arc::clone(&context), model_name);

    render_page(
        "create_entity",
        Arc::clone(&context),
        json!({ "model": model }),
    )
}
