use actix_web::{get, web, HttpResponse, Responder};
use serde_json::json;
use std::fs::read_to_string;

use crate::server::{utils::render::render_page, AppContext};

#[get("/")]
pub async fn index() -> impl Responder {
    HttpResponse::Found()
        .header("Location", "/dashboard")
        .finish()
}

#[get("/dashboard")]
pub async fn home(context: web::Data<AppContext>) -> impl Responder {
    render_page("home", context.into_inner(), json!({}))
}

#[get("/{filename:.*}")]
pub async fn static_file(
    web::Path(filename): web::Path<String>,
    context: web::Data<AppContext>,
) -> impl Responder {
    let mime = match filename.ends_with(".js") {
        true => "text/javascript",
        false => "text",
    };

    match read_to_string(format!("{}/public/{}", context.root, filename).as_str()) {
        Ok(html) => HttpResponse::Ok()
            .body(html)
            .with_header("Content-Type", mime),
        _ => HttpResponse::NotFound()
            .body("Not Found")
            .with_header("Content-Type", mime),
    }
}
