mod api;
mod args;
mod commands;
mod db;
mod embedded;
mod model;
mod project;
mod server;
mod template;
mod utils;

use args::parse_args;
use commands::{Command, HelpCommand, NewProjectCommand, StartProjectCommand};
use std::env;

fn main() {
    let raw_args: Vec<String> = env::args().collect();

    let (command_type, args) = parse_args(&raw_args);

    let command: Box<dyn Command> = match command_type.as_str() {
        "new" => Box::new(NewProjectCommand::new(args.get(0))),
        "start" => Box::new(StartProjectCommand::new(args.get(0))),
        _ => Box::new(HelpCommand {}),
    };

    if let Err(error) = &command.execute() {
        println!("Whoops: {:?}", error);
    }
}
