declare const feather: { replace(): void }

const getCreateModelAddFieldForm = () =>
  document.querySelector<HTMLFormElement>('#create-model-add-field-form')

const newModeLForm = document.querySelector<HTMLFormElement>('#new-model-form')
const newModelButton = document.querySelector('#new-model-btn')
const referenceModelSelect =
  document.querySelector<HTMLSelectElement>('#reference-model')

const iconsByType = {
  image: 'image',
  ref: 'link-2',
  text: 'type',
}

type Field = {
  name: string
  type: 'image' | 'ref' | 'text'
}

const newFields: Field[] = []

getCreateModelAddFieldForm()
  ?.querySelectorAll<HTMLButtonElement>(".button-row button[type='submit']")
  .forEach(btn =>
    btn.addEventListener('click', e => {
      e.preventDefault()
      const form = getCreateModelAddFieldForm()

      const nameInput =
        form?.querySelector<HTMLInputElement>("input[name='name']")

      const data = new FormData(form!)
      const newField: Field = {
        name: data.get('name')?.toString() ?? '',
        type: btn.value as 'ref',
      }

      if (newField.type === 'ref') {
        newField.name = referenceModelSelect!.value
      }

      nameInput?.classList.remove('error')

      if (!newField.name?.trim() && newField.type !== 'ref') {
        nameInput?.classList.add('error')
        return
      }

      nameInput!.value = ''

      const fieldList = document.querySelector('#new-model-fields')

      const item = document.createElement('li')

      item.innerHTML = `<span class="icon">
  <i title="Text" data-feather="${iconsByType[newField.type]}"></i>
</span>
<span class="name">${newField.name}</span>`

      fieldList?.appendChild(item)
      feather.replace()

      newFields.push(newField)

      document.querySelector('#no-field-comment')?.remove()
    })
  )

newModelButton?.addEventListener('click', async e => {
  e.preventDefault()

  const nameInput = newModeLForm?.querySelector<HTMLInputElement>(
    "input[name='model-name']"
  )
  nameInput?.classList.remove('error')

  const name = nameInput!.value

  if (!name.trim()) {
    nameInput?.classList.add('error')
    return
  }

  const res = await fetch('/models/new', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    body: JSON.stringify({
      name,
      fields: newFields,
    }),
  })

  if (res.ok) location.reload()
  else console.log(await res.text())
})
