use std::io::{stdin, stdout, Write};

pub fn prompt(question: &str, default: &str) -> String {
    let mut answer = String::new();

    if cfg!(test) {
        String::from(default)
    } else {
        print!("{}", question);
        stdout().flush().unwrap();
        match stdin().read_line(&mut answer) {
            Ok(1) => String::from(default),
            Ok(_) => answer.trim().to_string(),
            Err(_) => String::from(default),
        }
    }
}

#[cfg(test)]
mod io_tests {
    use super::*;

    #[test]
    fn test_prompt() {
        let result = prompt("What is the meaning of life? ", "42");
        assert_eq!(result, String::from("42"));
    }
}
