mod api;
mod args;
mod commands;
mod db;
mod model;
mod project;
mod server;
mod template;
mod utils;

use args::parse_args;
use commands::{help::help, new::create_project, start::start};
use std::{env, process};

fn main() {
    let raw_args: Vec<String> = env::args().collect();

    let (command, args) = parse_args(&raw_args);

    if let Err(e) = match command.as_str() {
        "new" => create_project(args),
        "start" => start(args),
        _ => help(),
    } {
        println!("Whoops: {}", e);
        process::exit(1);
    }
}
