use anyhow::Result;
use std::collections::HashMap;

pub fn help() -> Result<()> {
    let mut commands = HashMap::<&str, String>::new();

    commands.insert(
        "new [project name]",
        String::from("Creates an empty project."),
    );
    commands.insert(
        "start [root directory]",
        String::from("Starts the mezzo app."),
    );
    commands.insert("help", String::from("Prints this message."));

    println!("Usage: mezzo [command] [args] [flags]\n\nCommands");

    for (command, help_text) in commands {
        println!("    {}:\t{}", command, help_text);
    }

    Ok(())
}
