use crate::utils::io::prompt;

pub fn parse_args(raw_args: &Vec<String>) -> (String, Vec<String>) {
    match raw_args.get(1) {
        Some(value) => (value.clone(), raw_args[2..].to_vec()),
        _ => (String::from("help"), vec![]),
    }
}

pub fn arg_or_prompt(arg: Option<&String>, question: &str) -> String {
    if let Some(arg) = arg {
        arg.clone()
    } else {
        prompt(question, "")
    }
}

#[cfg(test)]
mod args_tests {
    use super::*;

    #[test]
    fn test_parse_args() {
        let raw_args: &Vec<String> = &vec!["mezzo", "new", "alma"]
            .iter()
            .map(|&s| String::from(s))
            .collect();

        let args = parse_args(raw_args);

        assert_eq!(args.0, "new");
        assert_eq!(args.1.len(), 1)
    }

    #[test]
    fn test_arg_or_prompt() {
        let result = arg_or_prompt(None, "What is the meaning of life?");
        assert_eq!(result, "");
    }
}
