use anyhow::Result;
use std::path::Path;
use swc::common::{
    errors::{ColorConfig, Handler},
    sync::Lrc,
    SourceMap,
};
use swc::config::Options;

pub fn compile_ts(source_path: &str) -> Result<String> {
    let cm: Lrc<SourceMap> = Default::default();
    let handler = Handler::with_tty_emitter(ColorConfig::Auto, true, false, Some(cm.clone()));

    let fm = cm.load_file(Path::new(source_path))?;

    let c = swc::Compiler::new(cm);

    let js = c
        .process_js_file(fm, &handler, &Options::default())
        .unwrap();

    Ok(js.code)
}
