use anyhow::Result;
use std::fs::File;
use std::io::Write;

pub fn create_file<C>(path: &str, content: C) -> Result<()>
where
    C: ToString,
{
    File::create(path)?.write(content.to_string().as_bytes())?;
    Ok(())
}

#[cfg(test)]
mod fs_tests {
    use std::fs::{read_to_string, remove_file};

    use super::*;

    #[test]
    fn test_create_file() {
        create_file("hello.txt", "Hello\nWorld").unwrap();
        let content = read_to_string("hello.txt").unwrap();
        assert_eq!(content, "Hello\nWorld");
        remove_file("hello.txt").unwrap();
    }
}
