use anyhow::Result;
use mongodb::{options::ClientOptions, Client};

pub async fn connect(uri: &str) -> Result<Client> {
    let client_options = ClientOptions::parse(uri).await?;
    let client = Client::with_options(client_options)?;

    Ok(client)
}
