use actix_web::{get, web, Responder};
use serde_json::json;

use crate::{
    api::ApiResult,
    server::{utils::render::render_page, AppContext},
};

#[get("/models/new")]
pub async fn create_model(context: web::Data<AppContext>) -> impl Responder {
    render_page("create_model", context.into_inner(), json!({}))
}

#[get("/models/{model_name}")]
pub async fn model_details(
    web::Path(model_name): web::Path<String>,
    context: web::Data<AppContext>,
) -> impl Responder {
    let ctx = context.into_inner();
    let model = ctx
        .project
        .models
        .clone()
        .into_iter()
        .find(|m| m.name == model_name)
        .unwrap();

    let data = match ctx.client.find_all(&model.name).await.unwrap() {
        ApiResult::Data(data) => Some(data),
        _ => None,
    };

    render_page(
        "model",
        ctx.clone(),
        json!({ "model": model, "entities": data }),
    )
}
