use std::net::SocketAddr;
use std::str::FromStr;
use std::time::Duration;

/// Demo for process-style metrics.
/// Open up http://127.0.0.1:3333 whilst it's running to see!
/// We must use Tokio as the Prometheus exporter requires to be called in a Tokio context...
/// (this seems like a bug in `metrics-exporter-prometheus`...?).
#[tokio::main]
pub async fn main() {
    metrics_exporter_prometheus::PrometheusBuilder::new()
        .with_http_listener(SocketAddr::from_str("127.0.0.1:3333").unwrap())
        .install()
        .expect("Can't build Prometheus exporter");

    // Describes the process metrics.
    metrics_process_promstyle::describe();

    std::thread::spawn(|| {
        // 5 seconds is maybe too fast in real-life use.
        std::thread::sleep(Duration::from_secs(5));

        // Emits the process metrics.
        metrics_process_promstyle::emit_now().expect("Failed to emit process metrics");
    });

    // Main program: sleep 2 minutes.
    std::thread::sleep(Duration::from_secs(120));
}
