# `metrics-process-promstyle`: Prometheus-style process metrics for the `metrics` façade

This crate provides Prometheus-style ['process metrics'][prom_process_metrics] for the backend-agnostic
[`metrics`][metrics_crate] façade.

Although these metrics use the conventional Prometheus names, they can be used with any `metrics`-compatible
exporter!

Process metrics are the following useful statistics:

- CPU time
- memory usage
- start time of the process
- number of threads

[prom_process_metrics]: https://prometheus.io/docs/instrumenting/writing_clientlibs/#process-metrics
[metrics_crate]: https://github.com/metrics-rs/metrics

Unimplemented process metrics:

- `process_open_fds`
- `process_max_fds`
- `process_virtual_memory_max_bytes`
- `process_heap_bytes`


## Usage

Once your metrics exporter is set up, you can describe the process metrics using `describe()`.

The `metrics` crate only provides for 'push'-style metrics; there's no way right now to emit statistics on demand.
For that reason, this crate exposes a function called `emit_now()` which, as the name implies, emits the statistics when called.
You'll need to call this occasionally (from a background thread or Tokio task etc, if necessary) to update the metrics.

(One day, it should be as easy as enabling a feature in this crate and calling the necessary function to set up a timer for you.)

See the `examples` directory for an example.


## Versioning

For simplicity's sake, this crate will follow the major version number of `metrics`, so it's easy to tell that compatible versions are being used.
This means that version `0.18.x` of this crate will be compatible with `metrics` `0.18.x`, and a hypothetical version `1.x.x` of this crate will be compatible with `metrics` `1.x.x`.


## Contributions

If you feel like you want to make a contribution, I would be very happy to accept.


## Licence

Licensed under either of

 * Apache Licence, Version 2.0
   ([LICENSE.Apache2](LICENSE.Apache2) or http://www.apache.org/licenses/LICENSE-2.0)
 * MIT Licence
   ([LICENSE.MIT](LICENSE.MIT) or http://opensource.org/licenses/MIT)

at your option.


## Contribution

Unless you explicitly state otherwise, any contribution intentionally submitted
for inclusion in the work by you, as defined in the Apache-2.0 licence, shall be
dual licensed as above, without any additional terms or conditions.
