use std::fmt;

#[derive(Debug)]
pub struct Error(jemalloc_ctl::Error);

impl std::error::Error for Error {}

impl fmt::Display for Error {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
		self.0.fmt(f)
	}
}

impl From<jemalloc_ctl::Error> for Error {
	#[inline]
	fn from(other: jemalloc_ctl::Error) -> Self {
		Self(other)
	}
}

