use super::Marker;

impl Into<u8> for Marker {
    fn into(self) -> u8 {
        match self {
            Self::PositiveFixInt(n) => n,
            Self::FixMap(n) => 0x80 | (n & 0x0f),
            Self::FixArray(n) => 0x90 | (n & 0x0f),
            Self::FixStr(n) => 0xa0 | (n & 0x1f),
            Self::Nil => 0xc0,
            Self::Reserved => 0xc1,
            Self::False => 0xc2,
            Self::True => 0xc3,
            Self::Bin8 => 0xc4,
            Self::Bin16 => 0xc5,
            Self::Bin32 => 0xc6,
            Self::Ext8 => 0xc7,
            Self::Ext16 => 0xc8,
            Self::Ext32 => 0xc9,
            Self::Float32 => 0xca,
            Self::Float64 => 0xcb,
            Self::UInt8 => 0xcc,
            Self::UInt16 => 0xcd,
            Self::UInt32 => 0xce,
            Self::UInt64 => 0xcf,
            Self::Int8 => 0xd0,
            Self::Int16 => 0xd1,
            Self::Int32 => 0xd2,
            Self::Int64 => 0xd3,
            Self::FixExt1 => 0xd4,
            Self::FixExt2 => 0xd5,
            Self::FixExt4 => 0xd6,
            Self::FixExt8 => 0xd7,
            Self::FixExt16 => 0xd8,
            Self::Str8 => 0xd9,
            Self::Str16 => 0xda,
            Self::Str32 => 0xdb,
            Self::Array16 => 0xdc,
            Self::Array32 => 0xdd,
            Self::Map16 => 0xde,
            Self::Map32 => 0xdf,
            Self::NegativeFixInt(n) => n as u8,
        }
    }
}
