use super::Marker;

impl From<u8> for Marker {
    fn from(n: u8) -> Marker {
        match n {
            0x00..=0x7f => Self::PositiveFixInt(n),
            0x80..=0x8f => Self::FixMap(n & 0x0f),
            0x90..=0x9f => Self::FixArray(n & 0x0f),
            0xa0..=0xbf => Self::FixStr(n & 0x1f),
            0xc0 => Self::Nil,
            0xc1 => Self::Reserved,
            0xc2 => Self::False,
            0xc3 => Self::True,
            0xc4 => Self::Bin8,
            0xc5 => Self::Bin16,
            0xc6 => Self::Bin32,
            0xc7 => Self::Ext8,
            0xc8 => Self::Ext16,
            0xc9 => Self::Ext32,
            0xca => Self::Float32,
            0xcb => Self::Float64,
            0xcc => Self::UInt8,
            0xcd => Self::UInt16,
            0xce => Self::UInt32,
            0xcf => Self::UInt64,
            0xd0 => Self::Int8,
            0xd1 => Self::Int16,
            0xd2 => Self::Int32,
            0xd3 => Self::Int64,
            0xd4 => Self::FixExt1,
            0xd5 => Self::FixExt2,
            0xd6 => Self::FixExt4,
            0xd7 => Self::FixExt8,
            0xd8 => Self::FixExt16,
            0xd9 => Self::Str8,
            0xda => Self::Str16,
            0xdb => Self::Str32,
            0xdc => Self::Array16,
            0xdd => Self::Array32,
            0xde => Self::Map16,
            0xdf => Self::Map32,
            0xe0..=0xff => Self::NegativeFixInt(n as i8),
        }
    }
}
