use chrono::Local;
use hyper::{Body, Client, Method, Request};
use notify_rust::{Notification};
use structopt::StructOpt;

#[derive(StructOpt, Debug)]
#[structopt(name = "basic")]
struct Opt {
    /// 消息发送对象
    #[structopt(short, long, default_value = "followyourdream")]
    user_id: String,

    /// 消息标题
    #[structopt(short, long, default_value = "操作成功")]
    title: String,

    /// 消息内容
    #[structopt(short, long, default_value = "✅")]
    message: String,
}

#[tokio::main]
async fn main() -> Result<(), Box<dyn std::error::Error + Send + Sync>> {
    let opt = Opt::from_args();
    // This is where we will setup our HTTP client requests.
    // Still inside `async fn main`...
    let client = Client::new();

    let date = Local::now();

    let content = format!(
        "---{}---\n{}\n{}",
        opt.title,
        date.format("%Y-%m-%d %H:%M:%S"),
        opt.message
    );

    let message = format!("userId={}&content={}", opt.user_id, content);

    let req = Request::builder()
        .method(Method::POST)
        .uri("http://127.0.0.1:52700/wechat-plugin/send-message")
        .body(Body::from(message))
        .expect("request builder");
    let resp = client.request(req).await?;

    println!("Response: {}", resp.status());

    Notification::new()
        .summary("Category:mail")
        .body(content.as_str())
        .icon("thunderbird")
        .appname("thunderbird")
        .timeout(0) // this however is
        .show()?;

    Ok(())
}
