mod cell; pub use cell::*;
mod context; pub use context::*;
mod dict; pub use dict::*;
mod sequence; pub use sequence::*;
mod time; pub use time::*;

#[cfg(test)] mod test;

pub trait Mergable: Sized {
	type Diff: Diff;

	fn merge(&mut self, other: Self) {
		self.apply(Mergable::diff(&other, self))
			.expect("Implementation error")
	}

	/** Produce a diff.
	 *
	 * The result will contain all of the information in `self` that isn't present in `that`.
	 */
	fn diff(&self, that: &Self) -> Self::Diff;

	fn apply(&mut self, diff: Self::Diff) -> Result<(), ApplyError>;
}

pub trait Diff: Sized {
	fn revert(self) -> Result<Self, RevertError>;
}

#[derive(Debug,thiserror::Error)]
#[non_exhaustive]
pub enum ApplyError {
	#[error("Apply target missing critical information: {0:?}")]
	Missing(String),
}

#[derive(Debug,thiserror::Error)]
#[non_exhaustive]
pub enum RevertError {
	#[error("Cannot revert, value has been undone and redone too many times.")]
	TooManyRedos,
	#[error("Apply target missing critical information: {0:?}")]
	Mismatch(String),
}

#[derive(Clone,Debug)]
pub struct Opaque<T>(T);
