
use crate::executive::world::World;
use std::fmt::Debug;
use std::collections::HashMap;
use std::sync::Arc;
use std::cell::RefCell;
use crate::logic::error::LogicError;
use crate::logic::builder::*;
use crate::logic::descriptor::{ParameterDescriptor, CoreModelDescriptor, DataTypeDescriptor, DataTypeStructureDescriptor, DataTypeTypeDescriptor, TreatmentDescriptor};
use crate::logic::descriptor::identifier::*;
use crate::executive::environment::{ContextualEnvironment, GenesisEnvironment};
use crate::executive::model::{Model, ModelId};

/*#[derive(Debug)]
pub struct CoreModelBuilder<T: Model> {
}

impl<T: Model> Builder for CoreModelBuilder<T> {

    fn static_build(&self, environment: &dyn GenesisEnvironment, params: &HashMap<String, Value>) {

        //let arc_model = Arc::new();
        //environment.register_model(model: Arc<dyn Model>)
    }

    fn dynamic_build(&self,  environment: &dyn ContextualEnvironment) {

    }
}*/

// Makes no sense to have generic builders for core elements: they should have their dedicated one generated by macros.

#[derive(Debug)]
pub struct CoreModelBuilder {
    new_model: fn(Arc<World>) -> Arc<dyn Model>,
}

impl CoreModelBuilder {

    pub fn new(new_model: fn(Arc<World>) -> Arc<dyn Model>) -> Self {
        Self {
            new_model
        }
    }
}

impl Builder for CoreModelBuilder {

    fn static_build(&self, host_treatment: Option<Arc<dyn TreatmentDescriptor>>, host_build: Option<BuildId>, label: String, environment: &GenesisEnvironment) -> Result<StaticBuildResult, LogicError> {

        let mut file_model = (self.new_model)(environment.world());

        for (name, value) in environment.variables() {
            file_model.set_parameter(name, value);
        }

        let id = environment.register_model(Arc::clone(&file_model) as Arc<dyn Model>);

        file_model.set_id(id);
        
        Ok(StaticBuildResult::Model(file_model))
    }

    fn dynamic_build(&self, build: BuildId, environment: &ContextualEnvironment) -> Option<DynamicBuildResult> {
        None
    }

    fn give_next(&self, within_build: BuildId, for_label: String, environment: &ContextualEnvironment) -> Option<DynamicBuildResult> {
        None
    }

    fn check_dynamic_build(&self, build: BuildId, environment: CheckEnvironment, previous_steps: Vec<CheckStep>) -> Option<CheckBuildResult> {
        None
    }

    fn check_give_next(&self, within_build: BuildId, for_label: String, environment: CheckEnvironment, previous_steps: Vec<CheckStep>) -> Option<CheckBuildResult> {
        None
    }
}



