/*
 * melib - gpgme module
 *
 * Copyright 2020 Manos Pitsidianakis
 *
 * This file is part of meli.
 *
 * meli is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * meli is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with meli. If not, see <http://www.gnu.org/licenses/>.
 */

#![allow(non_camel_case_types)]
#![allow(non_upper_case_globals)]
#![allow(non_snake_case)]
#![allow(unused)]
#![allow(dead_code)]
use libc::{off_t, time_t, FILE};

/* automatically generated by rust-bindgen */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage, Align> {
    storage: Storage,
    align: [Align; 0],
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage, align: [] }
    }
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const GPGME_VERSION: &'static str = "1.12.0\0";
pub const GPGME_VERSION_NUMBER: u32 = 68608;
pub const GPGME_KEYLIST_MODE_LOCAL: u32 = 1;
pub const GPGME_KEYLIST_MODE_EXTERN: u32 = 2;
pub const GPGME_KEYLIST_MODE_SIGS: u32 = 4;
pub const GPGME_KEYLIST_MODE_SIG_NOTATIONS: u32 = 8;
pub const GPGME_KEYLIST_MODE_WITH_SECRET: u32 = 16;
pub const GPGME_KEYLIST_MODE_WITH_TOFU: u32 = 32;
pub const GPGME_KEYLIST_MODE_EPHEMERAL: u32 = 128;
pub const GPGME_KEYLIST_MODE_VALIDATE: u32 = 256;
pub const GPGME_KEYLIST_MODE_LOCATE: u32 = 3;
pub const GPGME_EXPORT_MODE_EXTERN: u32 = 2;
pub const GPGME_EXPORT_MODE_MINIMAL: u32 = 4;
pub const GPGME_EXPORT_MODE_SECRET: u32 = 16;
pub const GPGME_EXPORT_MODE_RAW: u32 = 32;
pub const GPGME_EXPORT_MODE_PKCS12: u32 = 64;
pub const GPGME_EXPORT_MODE_NOUID: u32 = 128;
pub const GPGME_AUDITLOG_DEFAULT: u32 = 0;
pub const GPGME_AUDITLOG_HTML: u32 = 1;
pub const GPGME_AUDITLOG_DIAG: u32 = 2;
pub const GPGME_AUDITLOG_WITH_HELP: u32 = 128;
pub const GPGME_SIG_NOTATION_HUMAN_READABLE: u32 = 1;
pub const GPGME_SIG_NOTATION_CRITICAL: u32 = 2;
pub const GPGME_INCLUDE_CERTS_DEFAULT: i32 = -256;
pub const GPGME_IMPORT_NEW: u32 = 1;
pub const GPGME_IMPORT_UID: u32 = 2;
pub const GPGME_IMPORT_SIG: u32 = 4;
pub const GPGME_IMPORT_SUBKEY: u32 = 8;
pub const GPGME_IMPORT_SECRET: u32 = 16;
pub const GPGME_CREATE_SIGN: u32 = 1;
pub const GPGME_CREATE_ENCR: u32 = 2;
pub const GPGME_CREATE_CERT: u32 = 4;
pub const GPGME_CREATE_AUTH: u32 = 8;
pub const GPGME_CREATE_NOPASSWD: u32 = 128;
pub const GPGME_CREATE_SELFSIGNED: u32 = 256;
pub const GPGME_CREATE_NOSTORE: u32 = 512;
pub const GPGME_CREATE_WANTPUB: u32 = 1024;
pub const GPGME_CREATE_WANTSEC: u32 = 2048;
pub const GPGME_CREATE_FORCE: u32 = 4096;
pub const GPGME_CREATE_NOEXPIRE: u32 = 8192;
pub const GPGME_DELETE_ALLOW_SECRET: u32 = 1;
pub const GPGME_DELETE_FORCE: u32 = 2;
pub const GPGME_KEYSIGN_LOCAL: u32 = 128;
pub const GPGME_KEYSIGN_LFSEP: u32 = 256;
pub const GPGME_KEYSIGN_NOEXPIRE: u32 = 512;
pub const GPGME_INTERACT_CARD: u32 = 1;
pub const GPGME_SPAWN_DETACHED: u32 = 1;
pub const GPGME_SPAWN_ALLOW_SET_FG: u32 = 2;
pub const GPGME_SPAWN_SHOW_WINDOW: u32 = 4;
pub const GPGME_CONF_GROUP: u32 = 1;
pub const GPGME_CONF_OPTIONAL: u32 = 2;
pub const GPGME_CONF_LIST: u32 = 4;
pub const GPGME_CONF_RUNTIME: u32 = 8;
pub const GPGME_CONF_DEFAULT: u32 = 16;
pub const GPGME_CONF_DEFAULT_DESC: u32 = 32;
pub const GPGME_CONF_NO_ARG_DESC: u32 = 64;
pub const GPGME_CONF_NO_CHANGE: u32 = 128;

pub type gpg_err_source_t = u32;
pub type gpg_err_code_t = u32;
pub type gpg_error_t = ::std::os::raw::c_uint;
pub type gpg_strerror_r = unsafe extern "C" fn(
    err: gpg_error_t,
    buf: *mut ::std::os::raw::c_char,
    buflen: usize,
) -> ::std::os::raw::c_int;
extern "C" {
    pub fn gpg_err_code_from_errno(err: ::std::os::raw::c_int) -> gpg_err_code_t;
}
extern "C" {
    pub fn gpg_err_code_to_errno(code: gpg_err_code_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gpg_err_code_from_syserror() -> gpg_err_code_t;
}
extern "C" {
    pub fn gpg_error_check_version(
        req_version: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpgme_context {
    _unused: [u8; 0],
}
pub type gpgme_ctx_t = *mut gpgme_context;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpgme_data {
    _unused: [u8; 0],
}
pub type gpgme_data_t = *mut gpgme_data;
pub type gpgme_error_t = gpg_error_t;
pub use self::gpg_err_code_t as gpgme_err_code_t;
pub use self::gpg_err_source_t as gpgme_err_source_t;
extern "C" {
    pub fn gpgme_strerror(err: gpgme_error_t) -> *const ::std::os::raw::c_char;
}
pub type gpgme_strerror_r = unsafe extern "C" fn(
    err: gpg_error_t,
    buf: *mut ::std::os::raw::c_char,
    buflen: usize,
) -> ::std::os::raw::c_int;
extern "C" {
    pub fn gpgme_strsource(err: gpgme_error_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn gpgme_err_code_from_errno(err: ::std::os::raw::c_int) -> gpgme_err_code_t;
}
extern "C" {
    pub fn gpgme_err_code_to_errno(code: gpgme_err_code_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gpgme_err_code_from_syserror() -> gpgme_err_code_t;
}
extern "C" {
    pub fn gpgme_err_set_errno(err: ::std::os::raw::c_int);
}
extern "C" {
    pub fn gpgme_err_make_from_errno(
        source: gpgme_err_source_t,
        err: ::std::os::raw::c_int,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_error_from_errno(err: ::std::os::raw::c_int) -> gpgme_error_t;
}
pub const gpgme_data_encoding_t_GPGME_DATA_ENCODING_NONE: gpgme_data_encoding_t = 0;
pub const gpgme_data_encoding_t_GPGME_DATA_ENCODING_BINARY: gpgme_data_encoding_t = 1;
pub const gpgme_data_encoding_t_GPGME_DATA_ENCODING_BASE64: gpgme_data_encoding_t = 2;
pub const gpgme_data_encoding_t_GPGME_DATA_ENCODING_ARMOR: gpgme_data_encoding_t = 3;
pub const gpgme_data_encoding_t_GPGME_DATA_ENCODING_URL: gpgme_data_encoding_t = 4;
pub const gpgme_data_encoding_t_GPGME_DATA_ENCODING_URLESC: gpgme_data_encoding_t = 5;
pub const gpgme_data_encoding_t_GPGME_DATA_ENCODING_URL0: gpgme_data_encoding_t = 6;
pub const gpgme_data_encoding_t_GPGME_DATA_ENCODING_MIME: gpgme_data_encoding_t = 7;
pub type gpgme_data_encoding_t = u32;
pub const gpgme_data_type_t_GPGME_DATA_TYPE_INVALID: gpgme_data_type_t = 0;
pub const gpgme_data_type_t_GPGME_DATA_TYPE_UNKNOWN: gpgme_data_type_t = 1;
pub const gpgme_data_type_t_GPGME_DATA_TYPE_PGP_SIGNED: gpgme_data_type_t = 16;
pub const gpgme_data_type_t_GPGME_DATA_TYPE_PGP_ENCRYPTED: gpgme_data_type_t = 17;
pub const gpgme_data_type_t_GPGME_DATA_TYPE_PGP_OTHER: gpgme_data_type_t = 18;
pub const gpgme_data_type_t_GPGME_DATA_TYPE_PGP_KEY: gpgme_data_type_t = 19;
pub const gpgme_data_type_t_GPGME_DATA_TYPE_PGP_SIGNATURE: gpgme_data_type_t = 24;
pub const gpgme_data_type_t_GPGME_DATA_TYPE_CMS_SIGNED: gpgme_data_type_t = 32;
pub const gpgme_data_type_t_GPGME_DATA_TYPE_CMS_ENCRYPTED: gpgme_data_type_t = 33;
pub const gpgme_data_type_t_GPGME_DATA_TYPE_CMS_OTHER: gpgme_data_type_t = 34;
pub const gpgme_data_type_t_GPGME_DATA_TYPE_X509_CERT: gpgme_data_type_t = 35;
pub const gpgme_data_type_t_GPGME_DATA_TYPE_PKCS12: gpgme_data_type_t = 36;
pub type gpgme_data_type_t = u32;
pub const gpgme_pubkey_algo_t_GPGME_PK_RSA: gpgme_pubkey_algo_t = 1;
pub const gpgme_pubkey_algo_t_GPGME_PK_RSA_E: gpgme_pubkey_algo_t = 2;
pub const gpgme_pubkey_algo_t_GPGME_PK_RSA_S: gpgme_pubkey_algo_t = 3;
pub const gpgme_pubkey_algo_t_GPGME_PK_ELG_E: gpgme_pubkey_algo_t = 16;
pub const gpgme_pubkey_algo_t_GPGME_PK_DSA: gpgme_pubkey_algo_t = 17;
pub const gpgme_pubkey_algo_t_GPGME_PK_ECC: gpgme_pubkey_algo_t = 18;
pub const gpgme_pubkey_algo_t_GPGME_PK_ELG: gpgme_pubkey_algo_t = 20;
pub const gpgme_pubkey_algo_t_GPGME_PK_ECDSA: gpgme_pubkey_algo_t = 301;
pub const gpgme_pubkey_algo_t_GPGME_PK_ECDH: gpgme_pubkey_algo_t = 302;
pub const gpgme_pubkey_algo_t_GPGME_PK_EDDSA: gpgme_pubkey_algo_t = 303;
pub type gpgme_pubkey_algo_t = u32;
pub const gpgme_hash_algo_t_GPGME_MD_NONE: gpgme_hash_algo_t = 0;
pub const gpgme_hash_algo_t_GPGME_MD_MD5: gpgme_hash_algo_t = 1;
pub const gpgme_hash_algo_t_GPGME_MD_SHA1: gpgme_hash_algo_t = 2;
pub const gpgme_hash_algo_t_GPGME_MD_RMD160: gpgme_hash_algo_t = 3;
pub const gpgme_hash_algo_t_GPGME_MD_MD2: gpgme_hash_algo_t = 5;
pub const gpgme_hash_algo_t_GPGME_MD_TIGER: gpgme_hash_algo_t = 6;
pub const gpgme_hash_algo_t_GPGME_MD_HAVAL: gpgme_hash_algo_t = 7;
pub const gpgme_hash_algo_t_GPGME_MD_SHA256: gpgme_hash_algo_t = 8;
pub const gpgme_hash_algo_t_GPGME_MD_SHA384: gpgme_hash_algo_t = 9;
pub const gpgme_hash_algo_t_GPGME_MD_SHA512: gpgme_hash_algo_t = 10;
pub const gpgme_hash_algo_t_GPGME_MD_SHA224: gpgme_hash_algo_t = 11;
pub const gpgme_hash_algo_t_GPGME_MD_MD4: gpgme_hash_algo_t = 301;
pub const gpgme_hash_algo_t_GPGME_MD_CRC32: gpgme_hash_algo_t = 302;
pub const gpgme_hash_algo_t_GPGME_MD_CRC32_RFC1510: gpgme_hash_algo_t = 303;
pub const gpgme_hash_algo_t_GPGME_MD_CRC24_RFC2440: gpgme_hash_algo_t = 304;
pub type gpgme_hash_algo_t = u32;
pub const gpgme_sig_mode_t_GPGME_SIG_MODE_NORMAL: gpgme_sig_mode_t = 0;
pub const gpgme_sig_mode_t_GPGME_SIG_MODE_DETACH: gpgme_sig_mode_t = 1;
pub const gpgme_sig_mode_t_GPGME_SIG_MODE_CLEAR: gpgme_sig_mode_t = 2;
pub type gpgme_sig_mode_t = u32;
pub const gpgme_validity_t_GPGME_VALIDITY_UNKNOWN: gpgme_validity_t = 0;
pub const gpgme_validity_t_GPGME_VALIDITY_UNDEFINED: gpgme_validity_t = 1;
pub const gpgme_validity_t_GPGME_VALIDITY_NEVER: gpgme_validity_t = 2;
pub const gpgme_validity_t_GPGME_VALIDITY_MARGINAL: gpgme_validity_t = 3;
pub const gpgme_validity_t_GPGME_VALIDITY_FULL: gpgme_validity_t = 4;
pub const gpgme_validity_t_GPGME_VALIDITY_ULTIMATE: gpgme_validity_t = 5;
pub type gpgme_validity_t = u32;
pub const gpgme_tofu_policy_t_GPGME_TOFU_POLICY_NONE: gpgme_tofu_policy_t = 0;
pub const gpgme_tofu_policy_t_GPGME_TOFU_POLICY_AUTO: gpgme_tofu_policy_t = 1;
pub const gpgme_tofu_policy_t_GPGME_TOFU_POLICY_GOOD: gpgme_tofu_policy_t = 2;
pub const gpgme_tofu_policy_t_GPGME_TOFU_POLICY_UNKNOWN: gpgme_tofu_policy_t = 3;
pub const gpgme_tofu_policy_t_GPGME_TOFU_POLICY_BAD: gpgme_tofu_policy_t = 4;
pub const gpgme_tofu_policy_t_GPGME_TOFU_POLICY_ASK: gpgme_tofu_policy_t = 5;
pub type gpgme_tofu_policy_t = u32;
pub const gpgme_keyorg_t_GPGME_KEYORG_UNKNOWN: gpgme_keyorg_t = 0;
pub const gpgme_keyorg_t_GPGME_KEYORG_KS: gpgme_keyorg_t = 1;
pub const gpgme_keyorg_t_GPGME_KEYORG_DANE: gpgme_keyorg_t = 3;
pub const gpgme_keyorg_t_GPGME_KEYORG_WKD: gpgme_keyorg_t = 4;
pub const gpgme_keyorg_t_GPGME_KEYORG_URL: gpgme_keyorg_t = 5;
pub const gpgme_keyorg_t_GPGME_KEYORG_FILE: gpgme_keyorg_t = 6;
pub const gpgme_keyorg_t_GPGME_KEYORG_SELF: gpgme_keyorg_t = 7;
pub const gpgme_keyorg_t_GPGME_KEYORG_OTHER: gpgme_keyorg_t = 31;
pub type gpgme_keyorg_t = u32;
pub const gpgme_protocol_t_GPGME_PROTOCOL_OpenPGP: gpgme_protocol_t = 0;
pub const gpgme_protocol_t_GPGME_PROTOCOL_CMS: gpgme_protocol_t = 1;
pub const gpgme_protocol_t_GPGME_PROTOCOL_GPGCONF: gpgme_protocol_t = 2;
pub const gpgme_protocol_t_GPGME_PROTOCOL_ASSUAN: gpgme_protocol_t = 3;
pub const gpgme_protocol_t_GPGME_PROTOCOL_G13: gpgme_protocol_t = 4;
pub const gpgme_protocol_t_GPGME_PROTOCOL_UISERVER: gpgme_protocol_t = 5;
pub const gpgme_protocol_t_GPGME_PROTOCOL_SPAWN: gpgme_protocol_t = 6;
pub const gpgme_protocol_t_GPGME_PROTOCOL_DEFAULT: gpgme_protocol_t = 254;
pub const gpgme_protocol_t_GPGME_PROTOCOL_UNKNOWN: gpgme_protocol_t = 255;
pub type gpgme_protocol_t = u32;
pub type gpgme_keylist_mode_t = ::std::os::raw::c_uint;
pub const gpgme_pinentry_mode_t_GPGME_PINENTRY_MODE_DEFAULT: gpgme_pinentry_mode_t = 0;
pub const gpgme_pinentry_mode_t_GPGME_PINENTRY_MODE_ASK: gpgme_pinentry_mode_t = 1;
pub const gpgme_pinentry_mode_t_GPGME_PINENTRY_MODE_CANCEL: gpgme_pinentry_mode_t = 2;
pub const gpgme_pinentry_mode_t_GPGME_PINENTRY_MODE_ERROR: gpgme_pinentry_mode_t = 3;
pub const gpgme_pinentry_mode_t_GPGME_PINENTRY_MODE_LOOPBACK: gpgme_pinentry_mode_t = 4;
pub type gpgme_pinentry_mode_t = u32;
pub type gpgme_export_mode_t = ::std::os::raw::c_uint;
pub type gpgme_sig_notation_flags_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_sig_notation {
    pub next: *mut _gpgme_sig_notation,
    pub name: *mut ::std::os::raw::c_char,
    pub value: *mut ::std::os::raw::c_char,
    pub name_len: ::std::os::raw::c_int,
    pub value_len: ::std::os::raw::c_int,
    pub flags: gpgme_sig_notation_flags_t,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
}
#[test]
fn bindgen_test_layout__gpgme_sig_notation() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_sig_notation>(),
        40usize,
        concat!("Size of: ", stringify!(_gpgme_sig_notation))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_sig_notation>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_sig_notation))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_sig_notation>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_sig_notation),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_sig_notation>())).name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_sig_notation),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_sig_notation>())).value as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_sig_notation),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_sig_notation>())).name_len as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_sig_notation),
            "::",
            stringify!(name_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_sig_notation>())).value_len as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_sig_notation),
            "::",
            stringify!(value_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_sig_notation>())).flags as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_sig_notation),
            "::",
            stringify!(flags)
        )
    );
}
impl _gpgme_sig_notation {
    #[inline]
    pub fn human_readable(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_human_readable(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn critical(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_critical(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn _unused(&self) -> ::std::os::raw::c_int {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set__unused(&mut self, val: ::std::os::raw::c_int) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        human_readable: ::std::os::raw::c_uint,
        critical: ::std::os::raw::c_uint,
        _unused: ::std::os::raw::c_int,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let human_readable: u32 = unsafe { ::std::mem::transmute(human_readable) };
            human_readable as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let critical: u32 = unsafe { ::std::mem::transmute(critical) };
            critical as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let _unused: u32 = unsafe { ::std::mem::transmute(_unused) };
            _unused as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type gpgme_sig_notation_t = *mut _gpgme_sig_notation;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_engine_info {
    pub next: *mut _gpgme_engine_info,
    pub protocol: gpgme_protocol_t,
    pub file_name: *mut ::std::os::raw::c_char,
    pub version: *mut ::std::os::raw::c_char,
    pub req_version: *const ::std::os::raw::c_char,
    pub home_dir: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__gpgme_engine_info() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_engine_info>(),
        48usize,
        concat!("Size of: ", stringify!(_gpgme_engine_info))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_engine_info>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_engine_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_engine_info>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_engine_info),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_engine_info>())).protocol as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_engine_info),
            "::",
            stringify!(protocol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_engine_info>())).file_name as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_engine_info),
            "::",
            stringify!(file_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_engine_info>())).version as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_engine_info),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_engine_info>())).req_version as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_engine_info),
            "::",
            stringify!(req_version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_engine_info>())).home_dir as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_engine_info),
            "::",
            stringify!(home_dir)
        )
    );
}
pub type gpgme_engine_info_t = *mut _gpgme_engine_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_tofu_info {
    pub next: *mut _gpgme_tofu_info,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub signcount: ::std::os::raw::c_ushort,
    pub encrcount: ::std::os::raw::c_ushort,
    pub signfirst: ::std::os::raw::c_ulong,
    pub signlast: ::std::os::raw::c_ulong,
    pub encrfirst: ::std::os::raw::c_ulong,
    pub encrlast: ::std::os::raw::c_ulong,
    pub description: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__gpgme_tofu_info() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_tofu_info>(),
        56usize,
        concat!("Size of: ", stringify!(_gpgme_tofu_info))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_tofu_info>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_tofu_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_tofu_info>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_tofu_info),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_tofu_info>())).signcount as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_tofu_info),
            "::",
            stringify!(signcount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_tofu_info>())).encrcount as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_tofu_info),
            "::",
            stringify!(encrcount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_tofu_info>())).signfirst as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_tofu_info),
            "::",
            stringify!(signfirst)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_tofu_info>())).signlast as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_tofu_info),
            "::",
            stringify!(signlast)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_tofu_info>())).encrfirst as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_tofu_info),
            "::",
            stringify!(encrfirst)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_tofu_info>())).encrlast as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_tofu_info),
            "::",
            stringify!(encrlast)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_tofu_info>())).description as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_tofu_info),
            "::",
            stringify!(description)
        )
    );
}
impl _gpgme_tofu_info {
    #[inline]
    pub fn validity(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_validity(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn policy(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_policy(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn _rfu(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 25u8) as u32) }
    }
    #[inline]
    pub fn set__rfu(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 25u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        validity: ::std::os::raw::c_uint,
        policy: ::std::os::raw::c_uint,
        _rfu: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let validity: u32 = unsafe { ::std::mem::transmute(validity) };
            validity as u64
        });
        __bindgen_bitfield_unit.set(3usize, 4u8, {
            let policy: u32 = unsafe { ::std::mem::transmute(policy) };
            policy as u64
        });
        __bindgen_bitfield_unit.set(7usize, 25u8, {
            let _rfu: u32 = unsafe { ::std::mem::transmute(_rfu) };
            _rfu as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type gpgme_tofu_info_t = *mut _gpgme_tofu_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_subkey {
    pub next: *mut _gpgme_subkey,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub pubkey_algo: gpgme_pubkey_algo_t,
    pub length: ::std::os::raw::c_uint,
    pub keyid: *mut ::std::os::raw::c_char,
    pub _keyid: [::std::os::raw::c_char; 17usize],
    pub fpr: *mut ::std::os::raw::c_char,
    pub timestamp: ::std::os::raw::c_long,
    pub expires: ::std::os::raw::c_long,
    pub card_number: *mut ::std::os::raw::c_char,
    pub curve: *mut ::std::os::raw::c_char,
    pub keygrip: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__gpgme_subkey() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_subkey>(),
        104usize,
        concat!("Size of: ", stringify!(_gpgme_subkey))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_subkey>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_subkey))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_subkey>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_subkey),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_subkey>())).pubkey_algo as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_subkey),
            "::",
            stringify!(pubkey_algo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_subkey>())).length as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_subkey),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_subkey>())).keyid as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_subkey),
            "::",
            stringify!(keyid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_subkey>()))._keyid as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_subkey),
            "::",
            stringify!(_keyid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_subkey>())).fpr as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_subkey),
            "::",
            stringify!(fpr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_subkey>())).timestamp as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_subkey),
            "::",
            stringify!(timestamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_subkey>())).expires as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_subkey),
            "::",
            stringify!(expires)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_subkey>())).card_number as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_subkey),
            "::",
            stringify!(card_number)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_subkey>())).curve as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_subkey),
            "::",
            stringify!(curve)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_subkey>())).keygrip as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_subkey),
            "::",
            stringify!(keygrip)
        )
    );
}
impl _gpgme_subkey {
    #[inline]
    pub fn revoked(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_revoked(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn expired(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_expired(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn disabled(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_disabled(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn invalid(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_invalid(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn can_encrypt(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_can_encrypt(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn can_sign(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_can_sign(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn can_certify(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_can_certify(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn secret(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_secret(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn can_authenticate(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_can_authenticate(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_qualified(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_qualified(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_cardkey(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_cardkey(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_de_vs(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_de_vs(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn _unused(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 20u8) as u32) }
    }
    #[inline]
    pub fn set__unused(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 20u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        revoked: ::std::os::raw::c_uint,
        expired: ::std::os::raw::c_uint,
        disabled: ::std::os::raw::c_uint,
        invalid: ::std::os::raw::c_uint,
        can_encrypt: ::std::os::raw::c_uint,
        can_sign: ::std::os::raw::c_uint,
        can_certify: ::std::os::raw::c_uint,
        secret: ::std::os::raw::c_uint,
        can_authenticate: ::std::os::raw::c_uint,
        is_qualified: ::std::os::raw::c_uint,
        is_cardkey: ::std::os::raw::c_uint,
        is_de_vs: ::std::os::raw::c_uint,
        _unused: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let revoked: u32 = unsafe { ::std::mem::transmute(revoked) };
            revoked as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let expired: u32 = unsafe { ::std::mem::transmute(expired) };
            expired as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let disabled: u32 = unsafe { ::std::mem::transmute(disabled) };
            disabled as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let invalid: u32 = unsafe { ::std::mem::transmute(invalid) };
            invalid as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let can_encrypt: u32 = unsafe { ::std::mem::transmute(can_encrypt) };
            can_encrypt as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let can_sign: u32 = unsafe { ::std::mem::transmute(can_sign) };
            can_sign as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let can_certify: u32 = unsafe { ::std::mem::transmute(can_certify) };
            can_certify as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let secret: u32 = unsafe { ::std::mem::transmute(secret) };
            secret as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let can_authenticate: u32 = unsafe { ::std::mem::transmute(can_authenticate) };
            can_authenticate as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let is_qualified: u32 = unsafe { ::std::mem::transmute(is_qualified) };
            is_qualified as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let is_cardkey: u32 = unsafe { ::std::mem::transmute(is_cardkey) };
            is_cardkey as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let is_de_vs: u32 = unsafe { ::std::mem::transmute(is_de_vs) };
            is_de_vs as u64
        });
        __bindgen_bitfield_unit.set(12usize, 20u8, {
            let _unused: u32 = unsafe { ::std::mem::transmute(_unused) };
            _unused as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type gpgme_subkey_t = *mut _gpgme_subkey;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_key_sig {
    pub next: *mut _gpgme_key_sig,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub pubkey_algo: gpgme_pubkey_algo_t,
    pub keyid: *mut ::std::os::raw::c_char,
    pub _keyid: [::std::os::raw::c_char; 17usize],
    pub timestamp: ::std::os::raw::c_long,
    pub expires: ::std::os::raw::c_long,
    pub status: gpgme_error_t,
    pub class: ::std::os::raw::c_uint,
    pub uid: *mut ::std::os::raw::c_char,
    pub name: *mut ::std::os::raw::c_char,
    pub email: *mut ::std::os::raw::c_char,
    pub comment: *mut ::std::os::raw::c_char,
    pub sig_class: ::std::os::raw::c_uint,
    pub notations: gpgme_sig_notation_t,
    pub _last_notation: gpgme_sig_notation_t,
}
#[test]
fn bindgen_test_layout__gpgme_key_sig() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_key_sig>(),
        128usize,
        concat!("Size of: ", stringify!(_gpgme_key_sig))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_key_sig>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_key_sig))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key_sig>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key_sig),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key_sig>())).pubkey_algo as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key_sig),
            "::",
            stringify!(pubkey_algo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key_sig>())).keyid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key_sig),
            "::",
            stringify!(keyid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key_sig>()))._keyid as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key_sig),
            "::",
            stringify!(_keyid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key_sig>())).timestamp as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key_sig),
            "::",
            stringify!(timestamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key_sig>())).expires as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key_sig),
            "::",
            stringify!(expires)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key_sig>())).status as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key_sig),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key_sig>())).class as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key_sig),
            "::",
            stringify!(class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key_sig>())).uid as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key_sig),
            "::",
            stringify!(uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key_sig>())).name as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key_sig),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key_sig>())).email as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key_sig),
            "::",
            stringify!(email)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key_sig>())).comment as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key_sig),
            "::",
            stringify!(comment)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key_sig>())).sig_class as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key_sig),
            "::",
            stringify!(sig_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key_sig>())).notations as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key_sig),
            "::",
            stringify!(notations)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key_sig>()))._last_notation as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key_sig),
            "::",
            stringify!(_last_notation)
        )
    );
}
impl _gpgme_key_sig {
    #[inline]
    pub fn revoked(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_revoked(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn expired(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_expired(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn invalid(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_invalid(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn exportable(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_exportable(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn _unused(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 28u8) as u32) }
    }
    #[inline]
    pub fn set__unused(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 28u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        revoked: ::std::os::raw::c_uint,
        expired: ::std::os::raw::c_uint,
        invalid: ::std::os::raw::c_uint,
        exportable: ::std::os::raw::c_uint,
        _unused: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let revoked: u32 = unsafe { ::std::mem::transmute(revoked) };
            revoked as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let expired: u32 = unsafe { ::std::mem::transmute(expired) };
            expired as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let invalid: u32 = unsafe { ::std::mem::transmute(invalid) };
            invalid as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let exportable: u32 = unsafe { ::std::mem::transmute(exportable) };
            exportable as u64
        });
        __bindgen_bitfield_unit.set(4usize, 28u8, {
            let _unused: u32 = unsafe { ::std::mem::transmute(_unused) };
            _unused as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type gpgme_key_sig_t = *mut _gpgme_key_sig;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_user_id {
    pub next: *mut _gpgme_user_id,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub validity: gpgme_validity_t,
    pub uid: *mut ::std::os::raw::c_char,
    pub name: *mut ::std::os::raw::c_char,
    pub email: *mut ::std::os::raw::c_char,
    pub comment: *mut ::std::os::raw::c_char,
    pub signatures: gpgme_key_sig_t,
    pub _last_keysig: gpgme_key_sig_t,
    pub address: *mut ::std::os::raw::c_char,
    pub tofu: gpgme_tofu_info_t,
    pub last_update: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout__gpgme_user_id() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_user_id>(),
        88usize,
        concat!("Size of: ", stringify!(_gpgme_user_id))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_user_id>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_user_id))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_user_id>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_user_id),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_user_id>())).validity as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_user_id),
            "::",
            stringify!(validity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_user_id>())).uid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_user_id),
            "::",
            stringify!(uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_user_id>())).name as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_user_id),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_user_id>())).email as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_user_id),
            "::",
            stringify!(email)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_user_id>())).comment as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_user_id),
            "::",
            stringify!(comment)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_user_id>())).signatures as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_user_id),
            "::",
            stringify!(signatures)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_user_id>()))._last_keysig as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_user_id),
            "::",
            stringify!(_last_keysig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_user_id>())).address as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_user_id),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_user_id>())).tofu as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_user_id),
            "::",
            stringify!(tofu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_user_id>())).last_update as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_user_id),
            "::",
            stringify!(last_update)
        )
    );
}
impl _gpgme_user_id {
    #[inline]
    pub fn revoked(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_revoked(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn invalid(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_invalid(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn _unused(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 25u8) as u32) }
    }
    #[inline]
    pub fn set__unused(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 25u8, val as u64)
        }
    }
    #[inline]
    pub fn origin(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(27usize, 5u8) as u32) }
    }
    #[inline]
    pub fn set_origin(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(27usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        revoked: ::std::os::raw::c_uint,
        invalid: ::std::os::raw::c_uint,
        _unused: ::std::os::raw::c_uint,
        origin: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let revoked: u32 = unsafe { ::std::mem::transmute(revoked) };
            revoked as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let invalid: u32 = unsafe { ::std::mem::transmute(invalid) };
            invalid as u64
        });
        __bindgen_bitfield_unit.set(2usize, 25u8, {
            let _unused: u32 = unsafe { ::std::mem::transmute(_unused) };
            _unused as u64
        });
        __bindgen_bitfield_unit.set(27usize, 5u8, {
            let origin: u32 = unsafe { ::std::mem::transmute(origin) };
            origin as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type gpgme_user_id_t = *mut _gpgme_user_id;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_key {
    pub _refs: ::std::os::raw::c_uint,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub protocol: gpgme_protocol_t,
    pub issuer_serial: *mut ::std::os::raw::c_char,
    pub issuer_name: *mut ::std::os::raw::c_char,
    pub chain_id: *mut ::std::os::raw::c_char,
    pub owner_trust: gpgme_validity_t,
    pub subkeys: gpgme_subkey_t,
    pub uids: gpgme_user_id_t,
    pub _last_subkey: gpgme_subkey_t,
    pub _last_uid: gpgme_user_id_t,
    pub keylist_mode: gpgme_keylist_mode_t,
    pub fpr: *mut ::std::os::raw::c_char,
    pub last_update: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout__gpgme_key() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_key>(),
        104usize,
        concat!("Size of: ", stringify!(_gpgme_key))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_key>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_key))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key>()))._refs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key),
            "::",
            stringify!(_refs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key>())).protocol as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key),
            "::",
            stringify!(protocol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key>())).issuer_serial as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key),
            "::",
            stringify!(issuer_serial)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key>())).issuer_name as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key),
            "::",
            stringify!(issuer_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key>())).chain_id as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key),
            "::",
            stringify!(chain_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key>())).owner_trust as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key),
            "::",
            stringify!(owner_trust)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key>())).subkeys as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key),
            "::",
            stringify!(subkeys)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key>())).uids as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key),
            "::",
            stringify!(uids)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key>()))._last_subkey as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key),
            "::",
            stringify!(_last_subkey)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key>()))._last_uid as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key),
            "::",
            stringify!(_last_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key>())).keylist_mode as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key),
            "::",
            stringify!(keylist_mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key>())).fpr as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key),
            "::",
            stringify!(fpr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_key>())).last_update as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_key),
            "::",
            stringify!(last_update)
        )
    );
}
impl _gpgme_key {
    #[inline]
    pub fn revoked(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_revoked(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn expired(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_expired(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn disabled(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_disabled(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn invalid(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_invalid(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn can_encrypt(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_can_encrypt(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn can_sign(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_can_sign(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn can_certify(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_can_certify(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn secret(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_secret(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn can_authenticate(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_can_authenticate(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_qualified(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_qualified(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn _unused(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 17u8) as u32) }
    }
    #[inline]
    pub fn set__unused(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 17u8, val as u64)
        }
    }
    #[inline]
    pub fn origin(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(27usize, 5u8) as u32) }
    }
    #[inline]
    pub fn set_origin(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(27usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        revoked: ::std::os::raw::c_uint,
        expired: ::std::os::raw::c_uint,
        disabled: ::std::os::raw::c_uint,
        invalid: ::std::os::raw::c_uint,
        can_encrypt: ::std::os::raw::c_uint,
        can_sign: ::std::os::raw::c_uint,
        can_certify: ::std::os::raw::c_uint,
        secret: ::std::os::raw::c_uint,
        can_authenticate: ::std::os::raw::c_uint,
        is_qualified: ::std::os::raw::c_uint,
        _unused: ::std::os::raw::c_uint,
        origin: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let revoked: u32 = unsafe { ::std::mem::transmute(revoked) };
            revoked as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let expired: u32 = unsafe { ::std::mem::transmute(expired) };
            expired as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let disabled: u32 = unsafe { ::std::mem::transmute(disabled) };
            disabled as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let invalid: u32 = unsafe { ::std::mem::transmute(invalid) };
            invalid as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let can_encrypt: u32 = unsafe { ::std::mem::transmute(can_encrypt) };
            can_encrypt as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let can_sign: u32 = unsafe { ::std::mem::transmute(can_sign) };
            can_sign as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let can_certify: u32 = unsafe { ::std::mem::transmute(can_certify) };
            can_certify as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let secret: u32 = unsafe { ::std::mem::transmute(secret) };
            secret as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let can_authenticate: u32 = unsafe { ::std::mem::transmute(can_authenticate) };
            can_authenticate as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let is_qualified: u32 = unsafe { ::std::mem::transmute(is_qualified) };
            is_qualified as u64
        });
        __bindgen_bitfield_unit.set(10usize, 17u8, {
            let _unused: u32 = unsafe { ::std::mem::transmute(_unused) };
            _unused as u64
        });
        __bindgen_bitfield_unit.set(27usize, 5u8, {
            let origin: u32 = unsafe { ::std::mem::transmute(origin) };
            origin as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type gpgme_key_t = *mut _gpgme_key;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_invalid_key {
    pub next: *mut _gpgme_invalid_key,
    pub fpr: *mut ::std::os::raw::c_char,
    pub reason: gpgme_error_t,
}
#[test]
fn bindgen_test_layout__gpgme_invalid_key() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_invalid_key>(),
        24usize,
        concat!("Size of: ", stringify!(_gpgme_invalid_key))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_invalid_key>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_invalid_key))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_invalid_key>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_invalid_key),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_invalid_key>())).fpr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_invalid_key),
            "::",
            stringify!(fpr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_invalid_key>())).reason as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_invalid_key),
            "::",
            stringify!(reason)
        )
    );
}
pub type gpgme_invalid_key_t = *mut _gpgme_invalid_key;
pub type gpgme_passphrase_cb_t = ::std::option::Option<
    unsafe extern "C" fn(
        hook: *mut ::std::os::raw::c_void,
        uid_hint: *const ::std::os::raw::c_char,
        passphrase_info: *const ::std::os::raw::c_char,
        prev_was_bad: ::std::os::raw::c_int,
        fd: ::std::os::raw::c_int,
    ) -> gpgme_error_t,
>;
pub type gpgme_progress_cb_t = ::std::option::Option<
    unsafe extern "C" fn(
        opaque: *mut ::std::os::raw::c_void,
        what: *const ::std::os::raw::c_char,
        type_: ::std::os::raw::c_int,
        current: ::std::os::raw::c_int,
        total: ::std::os::raw::c_int,
    ),
>;
pub type gpgme_status_cb_t = ::std::option::Option<
    unsafe extern "C" fn(
        opaque: *mut ::std::os::raw::c_void,
        keyword: *const ::std::os::raw::c_char,
        args: *const ::std::os::raw::c_char,
    ) -> gpgme_error_t,
>;
pub type gpgme_interact_cb_t = ::std::option::Option<
    unsafe extern "C" fn(
        opaque: *mut ::std::os::raw::c_void,
        keyword: *const ::std::os::raw::c_char,
        args: *const ::std::os::raw::c_char,
        fd: ::std::os::raw::c_int,
    ) -> gpgme_error_t,
>;
pub type gpgme_new = unsafe extern "C" fn(ctx: *mut gpgme_ctx_t) -> gpgme_error_t;
pub type gpgme_release = unsafe extern "C" fn(ctx: gpgme_ctx_t);
pub type gpgme_set_ctx_flag = unsafe extern "C" fn(
    ctx: gpgme_ctx_t,
    name: *const ::std::os::raw::c_char,
    value: *const ::std::os::raw::c_char,
) -> gpgme_error_t;

pub type gpgme_get_ctx_flag = unsafe extern "C" fn(
    ctx: gpgme_ctx_t,
    name: *const ::std::os::raw::c_char,
) -> *const ::std::os::raw::c_char;
extern "C" {
    pub fn gpgme_set_protocol(ctx: gpgme_ctx_t, proto: gpgme_protocol_t) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_get_protocol(ctx: gpgme_ctx_t) -> gpgme_protocol_t;
}
extern "C" {
    pub fn gpgme_set_sub_protocol(ctx: gpgme_ctx_t, proto: gpgme_protocol_t) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_get_sub_protocol(ctx: gpgme_ctx_t) -> gpgme_protocol_t;
}
extern "C" {
    pub fn gpgme_get_protocol_name(proto: gpgme_protocol_t) -> *const ::std::os::raw::c_char;
}
pub type gpgme_set_armor = unsafe extern "C" fn(ctx: gpgme_ctx_t, yes: ::std::os::raw::c_int);
pub type gpgme_get_armor = unsafe extern "C" fn(ctx: gpgme_ctx_t) -> ::std::os::raw::c_int;
extern "C" {
    pub fn gpgme_set_textmode(ctx: gpgme_ctx_t, yes: ::std::os::raw::c_int);
}
extern "C" {
    pub fn gpgme_get_textmode(ctx: gpgme_ctx_t) -> ::std::os::raw::c_int;
}
pub type gpgme_set_offline = extern "C" fn(ctx: gpgme_ctx_t, yes: ::std::os::raw::c_int);
pub type gpgme_get_offline = extern "C" fn(ctx: gpgme_ctx_t) -> ::std::os::raw::c_int;
extern "C" {
    pub fn gpgme_set_include_certs(ctx: gpgme_ctx_t, nr_of_certs: ::std::os::raw::c_int);
}
extern "C" {
    pub fn gpgme_get_include_certs(ctx: gpgme_ctx_t) -> ::std::os::raw::c_int;
}
pub type gpgme_set_keylist_mode =
    unsafe extern "C" fn(ctx: gpgme_ctx_t, mode: gpgme_keylist_mode_t) -> gpgme_error_t;
pub type gpgme_get_keylist_mode = unsafe extern "C" fn(ctx: gpgme_ctx_t) -> gpgme_keylist_mode_t;
extern "C" {
    pub fn gpgme_set_pinentry_mode(ctx: gpgme_ctx_t, mode: gpgme_pinentry_mode_t) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_get_pinentry_mode(ctx: gpgme_ctx_t) -> gpgme_pinentry_mode_t;
}
extern "C" {
    pub fn gpgme_set_passphrase_cb(
        ctx: gpgme_ctx_t,
        cb: gpgme_passphrase_cb_t,
        hook_value: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn gpgme_get_passphrase_cb(
        ctx: gpgme_ctx_t,
        cb: *mut gpgme_passphrase_cb_t,
        hook_value: *mut *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn gpgme_set_progress_cb(
        c: gpgme_ctx_t,
        cb: gpgme_progress_cb_t,
        hook_value: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn gpgme_get_progress_cb(
        ctx: gpgme_ctx_t,
        cb: *mut gpgme_progress_cb_t,
        hook_value: *mut *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn gpgme_set_status_cb(
        c: gpgme_ctx_t,
        cb: gpgme_status_cb_t,
        hook_value: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn gpgme_get_status_cb(
        ctx: gpgme_ctx_t,
        cb: *mut gpgme_status_cb_t,
        hook_value: *mut *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn gpgme_set_locale(
        ctx: gpgme_ctx_t,
        category: ::std::os::raw::c_int,
        value: *const ::std::os::raw::c_char,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_ctx_get_engine_info(ctx: gpgme_ctx_t) -> gpgme_engine_info_t;
}
extern "C" {
    pub fn gpgme_ctx_set_engine_info(
        ctx: gpgme_ctx_t,
        proto: gpgme_protocol_t,
        file_name: *const ::std::os::raw::c_char,
        home_dir: *const ::std::os::raw::c_char,
    ) -> gpgme_error_t;
}
pub type gpgme_signers_clear = unsafe extern "C" fn(ctx: gpgme_ctx_t);

pub type gpgme_signers_add =
    unsafe extern "C" fn(ctx: gpgme_ctx_t, key: gpgme_key_t) -> gpgme_error_t;
extern "C" {
    pub fn gpgme_signers_count(ctx: gpgme_ctx_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn gpgme_signers_enum(ctx: gpgme_ctx_t, seq: ::std::os::raw::c_int) -> gpgme_key_t;
}
extern "C" {
    pub fn gpgme_sig_notation_clear(ctx: gpgme_ctx_t);
}
extern "C" {
    pub fn gpgme_sig_notation_add(
        ctx: gpgme_ctx_t,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        flags: gpgme_sig_notation_flags_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_sig_notation_get(ctx: gpgme_ctx_t) -> gpgme_sig_notation_t;
}
extern "C" {
    pub fn gpgme_set_sender(
        ctx: gpgme_ctx_t,
        address: *const ::std::os::raw::c_char,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_get_sender(ctx: gpgme_ctx_t) -> *const ::std::os::raw::c_char;
}
pub type gpgme_io_cb_t = ::std::option::Option<
    unsafe extern "C" fn(
        data: *mut ::std::os::raw::c_void,
        fd: ::std::os::raw::c_int,
    ) -> gpgme_error_t,
>;
pub type gpgme_register_io_cb_t = ::std::option::Option<
    unsafe extern "C" fn(
        data: *mut ::std::os::raw::c_void,
        fd: ::std::os::raw::c_int,
        dir: ::std::os::raw::c_int,
        fnc: gpgme_io_cb_t,
        fnc_data: *mut ::std::os::raw::c_void,
        tag: *mut *mut ::std::os::raw::c_void,
    ) -> gpgme_error_t,
>;
pub type gpgme_remove_io_cb_t =
    ::std::option::Option<unsafe extern "C" fn(tag: *mut ::std::os::raw::c_void)>;
pub const gpgme_event_io_t_GPGME_EVENT_START: gpgme_event_io_t = 0;
pub const gpgme_event_io_t_GPGME_EVENT_DONE: gpgme_event_io_t = 1;
pub const gpgme_event_io_t_GPGME_EVENT_NEXT_KEY: gpgme_event_io_t = 2;
pub const gpgme_event_io_t_GPGME_EVENT_NEXT_TRUSTITEM: gpgme_event_io_t = 3;
pub type gpgme_event_io_t = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpgme_io_event_done_data {
    pub err: gpgme_error_t,
    pub op_err: gpgme_error_t,
}
#[test]
fn bindgen_test_layout_gpgme_io_event_done_data() {
    assert_eq!(
        ::std::mem::size_of::<gpgme_io_event_done_data>(),
        8usize,
        concat!("Size of: ", stringify!(gpgme_io_event_done_data))
    );
    assert_eq!(
        ::std::mem::align_of::<gpgme_io_event_done_data>(),
        4usize,
        concat!("Alignment of ", stringify!(gpgme_io_event_done_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_io_event_done_data>())).err as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_io_event_done_data),
            "::",
            stringify!(err)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_io_event_done_data>())).op_err as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_io_event_done_data),
            "::",
            stringify!(op_err)
        )
    );
}
pub type gpgme_io_event_done_data_t = *mut gpgme_io_event_done_data;
pub type gpgme_event_io_cb_t = ::std::option::Option<
    unsafe extern "C" fn(
        data: *mut ::std::os::raw::c_void,
        type_: gpgme_event_io_t,
        type_data: *mut ::std::os::raw::c_void,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpgme_io_cbs {
    pub add: gpgme_register_io_cb_t,
    pub add_priv: *mut ::std::os::raw::c_void,
    pub remove: gpgme_remove_io_cb_t,
    pub event: gpgme_event_io_cb_t,
    pub event_priv: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_gpgme_io_cbs() {
    assert_eq!(
        ::std::mem::size_of::<gpgme_io_cbs>(),
        40usize,
        concat!("Size of: ", stringify!(gpgme_io_cbs))
    );
    assert_eq!(
        ::std::mem::align_of::<gpgme_io_cbs>(),
        8usize,
        concat!("Alignment of ", stringify!(gpgme_io_cbs))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_io_cbs>())).add as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_io_cbs),
            "::",
            stringify!(add)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_io_cbs>())).add_priv as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_io_cbs),
            "::",
            stringify!(add_priv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_io_cbs>())).remove as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_io_cbs),
            "::",
            stringify!(remove)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_io_cbs>())).event as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_io_cbs),
            "::",
            stringify!(event)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_io_cbs>())).event_priv as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_io_cbs),
            "::",
            stringify!(event_priv)
        )
    );
}
pub type gpgme_io_cbs_t = *mut gpgme_io_cbs;
pub type gpgme_set_io_cbs = unsafe extern "C" fn(ctx: gpgme_ctx_t, io_cbs: gpgme_io_cbs_t);
extern "C" {
    pub fn gpgme_get_io_cbs(ctx: gpgme_ctx_t, io_cbs: gpgme_io_cbs_t);
}
extern "C" {
    pub fn gpgme_io_read(
        fd: ::std::os::raw::c_int,
        buffer: *mut ::std::os::raw::c_void,
        count: usize,
    ) -> isize;
}
extern "C" {
    pub fn gpgme_io_write(
        fd: ::std::os::raw::c_int,
        buffer: *const ::std::os::raw::c_void,
        count: usize,
    ) -> isize;
}
extern "C" {
    pub fn gpgme_io_writen(
        fd: ::std::os::raw::c_int,
        buffer: *const ::std::os::raw::c_void,
        count: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gpgme_wait(
        ctx: gpgme_ctx_t,
        status: *mut gpgme_error_t,
        hang: ::std::os::raw::c_int,
    ) -> gpgme_ctx_t;
}
extern "C" {
    pub fn gpgme_wait_ext(
        ctx: gpgme_ctx_t,
        status: *mut gpgme_error_t,
        op_err: *mut gpgme_error_t,
        hang: ::std::os::raw::c_int,
    ) -> gpgme_ctx_t;
}
extern "C" {
    pub fn gpgme_cancel(ctx: gpgme_ctx_t) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_cancel_async(ctx: gpgme_ctx_t) -> gpgme_error_t;
}
pub type gpgme_data_read_cb_t = ::std::option::Option<
    unsafe extern "C" fn(
        handle: *mut ::std::os::raw::c_void,
        buffer: *mut ::std::os::raw::c_void,
        size: usize,
    ) -> isize,
>;
pub type gpgme_data_write_cb_t = ::std::option::Option<
    unsafe extern "C" fn(
        handle: *mut ::std::os::raw::c_void,
        buffer: *const ::std::os::raw::c_void,
        size: usize,
    ) -> isize,
>;
pub type gpgme_data_seek_cb_t = ::std::option::Option<
    unsafe extern "C" fn(
        handle: *mut ::std::os::raw::c_void,
        offset: off_t,
        whence: ::std::os::raw::c_int,
    ) -> off_t,
>;
pub type gpgme_data_release_cb_t =
    ::std::option::Option<unsafe extern "C" fn(handle: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpgme_data_cbs {
    pub read: gpgme_data_read_cb_t,
    pub write: gpgme_data_write_cb_t,
    pub seek: gpgme_data_seek_cb_t,
    pub release: gpgme_data_release_cb_t,
}
#[test]
fn bindgen_test_layout_gpgme_data_cbs() {
    assert_eq!(
        ::std::mem::size_of::<gpgme_data_cbs>(),
        32usize,
        concat!("Size of: ", stringify!(gpgme_data_cbs))
    );
    assert_eq!(
        ::std::mem::align_of::<gpgme_data_cbs>(),
        8usize,
        concat!("Alignment of ", stringify!(gpgme_data_cbs))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_data_cbs>())).read as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_data_cbs),
            "::",
            stringify!(read)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_data_cbs>())).write as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_data_cbs),
            "::",
            stringify!(write)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_data_cbs>())).seek as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_data_cbs),
            "::",
            stringify!(seek)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_data_cbs>())).release as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_data_cbs),
            "::",
            stringify!(release)
        )
    );
}
pub type gpgme_data_cbs_t = *mut gpgme_data_cbs;
pub type gpgme_data_read = unsafe extern "C" fn(
    dh: gpgme_data_t,
    buffer: *mut ::std::os::raw::c_void,
    size: usize,
) -> isize;
pub type gpgme_data_write = unsafe extern "C" fn(
    dh: gpgme_data_t,
    buffer: *const ::std::os::raw::c_void,
    size: usize,
) -> isize;
pub type gpgme_data_seek =
    unsafe extern "C" fn(dh: gpgme_data_t, offset: off_t, whence: ::std::os::raw::c_int) -> off_t;
pub type gpgme_data_new = unsafe extern "C" fn(r_dh: *mut gpgme_data_t) -> gpgme_error_t;
pub type gpgme_data_release = unsafe extern "C" fn(dh: gpgme_data_t);
pub type gpgme_data_new_from_mem = unsafe extern "C" fn(
    r_dh: *mut gpgme_data_t,
    buffer: *const ::std::os::raw::c_char,
    size: usize,
    copy: ::std::os::raw::c_int,
) -> gpgme_error_t;
extern "C" {
    pub fn gpgme_data_release_and_get_mem(
        dh: gpgme_data_t,
        r_len: *mut usize,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gpgme_free(buffer: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn gpgme_data_new_from_cbs(
        dh: *mut gpgme_data_t,
        cbs: gpgme_data_cbs_t,
        handle: *mut ::std::os::raw::c_void,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_data_new_from_fd(
        dh: *mut gpgme_data_t,
        fd: ::std::os::raw::c_int,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_data_get_encoding(dh: gpgme_data_t) -> gpgme_data_encoding_t;
}
extern "C" {
    pub fn gpgme_data_set_encoding(dh: gpgme_data_t, enc: gpgme_data_encoding_t) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_data_get_file_name(dh: gpgme_data_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gpgme_data_set_file_name(
        dh: gpgme_data_t,
        file_name: *const ::std::os::raw::c_char,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_data_set_flag(
        dh: gpgme_data_t,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
    ) -> gpg_error_t;
}
extern "C" {
    pub fn gpgme_data_identify(
        dh: gpgme_data_t,
        reserved: ::std::os::raw::c_int,
    ) -> gpgme_data_type_t;
}
pub type gpgme_data_new_from_file = unsafe extern "C" fn(
    r_dh: *mut gpgme_data_t,
    fname: *const ::std::os::raw::c_char,
    copy: ::std::os::raw::c_int,
) -> gpgme_error_t;

extern "C" {
    pub fn gpgme_data_new_from_filepart(
        r_dh: *mut gpgme_data_t,
        fname: *const ::std::os::raw::c_char,
        fp: *mut FILE,
        offset: off_t,
        length: usize,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_data_rewind(dh: gpgme_data_t) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_get_key(
        ctx: gpgme_ctx_t,
        fpr: *const ::std::os::raw::c_char,
        r_key: *mut gpgme_key_t,
        secret: ::std::os::raw::c_int,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_key_from_uid(
        key: *mut gpgme_key_t,
        name: *const ::std::os::raw::c_char,
    ) -> gpgme_error_t;
}
pub type gpgme_key_ref = unsafe extern "C" fn(key: gpgme_key_t);
pub type gpgme_key_unref = unsafe extern "C" fn(key: gpgme_key_t);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_op_encrypt_result {
    pub invalid_recipients: gpgme_invalid_key_t,
}
#[test]
fn bindgen_test_layout__gpgme_op_encrypt_result() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_op_encrypt_result>(),
        8usize,
        concat!("Size of: ", stringify!(_gpgme_op_encrypt_result))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_op_encrypt_result>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_op_encrypt_result))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_encrypt_result>())).invalid_recipients as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_encrypt_result),
            "::",
            stringify!(invalid_recipients)
        )
    );
}
pub type gpgme_encrypt_result_t = *mut _gpgme_op_encrypt_result;
pub type gpgme_op_encrypt_result = unsafe extern "C" fn(ctx: gpgme_ctx_t) -> gpgme_encrypt_result_t;
pub const gpgme_encrypt_flags_t_GPGME_ENCRYPT_ALWAYS_TRUST: gpgme_encrypt_flags_t = 1;
pub const gpgme_encrypt_flags_t_GPGME_ENCRYPT_NO_ENCRYPT_TO: gpgme_encrypt_flags_t = 2;
pub const gpgme_encrypt_flags_t_GPGME_ENCRYPT_PREPARE: gpgme_encrypt_flags_t = 4;
pub const gpgme_encrypt_flags_t_GPGME_ENCRYPT_EXPECT_SIGN: gpgme_encrypt_flags_t = 8;
pub const gpgme_encrypt_flags_t_GPGME_ENCRYPT_NO_COMPRESS: gpgme_encrypt_flags_t = 16;
pub const gpgme_encrypt_flags_t_GPGME_ENCRYPT_SYMMETRIC: gpgme_encrypt_flags_t = 32;
pub const gpgme_encrypt_flags_t_GPGME_ENCRYPT_THROW_KEYIDS: gpgme_encrypt_flags_t = 64;
pub const gpgme_encrypt_flags_t_GPGME_ENCRYPT_WRAP: gpgme_encrypt_flags_t = 128;
pub const gpgme_encrypt_flags_t_GPGME_ENCRYPT_WANT_ADDRESS: gpgme_encrypt_flags_t = 256;
pub type gpgme_encrypt_flags_t = u32;
pub type gpgme_op_encrypt_start = unsafe extern "C" fn(
    ctx: gpgme_ctx_t,
    recp: *mut gpgme_key_t,
    flags: gpgme_encrypt_flags_t,
    plain: gpgme_data_t,
    cipher: gpgme_data_t,
) -> gpgme_error_t;
extern "C" {
    pub fn gpgme_op_encrypt(
        ctx: gpgme_ctx_t,
        recp: *mut gpgme_key_t,
        flags: gpgme_encrypt_flags_t,
        plain: gpgme_data_t,
        cipher: gpgme_data_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_encrypt_ext_start(
        ctx: gpgme_ctx_t,
        recp: *mut gpgme_key_t,
        recpstring: *const ::std::os::raw::c_char,
        flags: gpgme_encrypt_flags_t,
        plain: gpgme_data_t,
        cipher: gpgme_data_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_encrypt_ext(
        ctx: gpgme_ctx_t,
        recp: *mut gpgme_key_t,
        recpstring: *const ::std::os::raw::c_char,
        flags: gpgme_encrypt_flags_t,
        plain: gpgme_data_t,
        cipher: gpgme_data_t,
    ) -> gpgme_error_t;
}
pub type gpgme_op_encrypt_sign_start = unsafe extern "C" fn(
    ctx: gpgme_ctx_t,
    recp: *mut gpgme_key_t,
    flags: gpgme_encrypt_flags_t,
    plain: gpgme_data_t,
    cipher: gpgme_data_t,
) -> gpgme_error_t;
extern "C" {
    pub fn gpgme_op_encrypt_sign(
        ctx: gpgme_ctx_t,
        recp: *mut gpgme_key_t,
        flags: gpgme_encrypt_flags_t,
        plain: gpgme_data_t,
        cipher: gpgme_data_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_encrypt_sign_ext_start(
        ctx: gpgme_ctx_t,
        recp: *mut gpgme_key_t,
        recpstring: *const ::std::os::raw::c_char,
        flags: gpgme_encrypt_flags_t,
        plain: gpgme_data_t,
        cipher: gpgme_data_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_encrypt_sign_ext(
        ctx: gpgme_ctx_t,
        recp: *mut gpgme_key_t,
        recpstring: *const ::std::os::raw::c_char,
        flags: gpgme_encrypt_flags_t,
        plain: gpgme_data_t,
        cipher: gpgme_data_t,
    ) -> gpgme_error_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_recipient {
    pub next: *mut _gpgme_recipient,
    pub keyid: *mut ::std::os::raw::c_char,
    pub _keyid: [::std::os::raw::c_char; 17usize],
    pub pubkey_algo: gpgme_pubkey_algo_t,
    pub status: gpgme_error_t,
}
#[test]
fn bindgen_test_layout__gpgme_recipient() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_recipient>(),
        48usize,
        concat!("Size of: ", stringify!(_gpgme_recipient))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_recipient>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_recipient))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_recipient>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_recipient),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_recipient>())).keyid as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_recipient),
            "::",
            stringify!(keyid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_recipient>()))._keyid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_recipient),
            "::",
            stringify!(_keyid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_recipient>())).pubkey_algo as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_recipient),
            "::",
            stringify!(pubkey_algo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_recipient>())).status as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_recipient),
            "::",
            stringify!(status)
        )
    );
}
pub type gpgme_recipient_t = *mut _gpgme_recipient;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_op_decrypt_result {
    pub unsupported_algorithm: *mut ::std::os::raw::c_char,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub recipients: gpgme_recipient_t,
    pub file_name: *mut ::std::os::raw::c_char,
    pub session_key: *mut ::std::os::raw::c_char,
    pub symkey_algo: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__gpgme_op_decrypt_result() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_op_decrypt_result>(),
        48usize,
        concat!("Size of: ", stringify!(_gpgme_op_decrypt_result))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_op_decrypt_result>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_op_decrypt_result))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_decrypt_result>())).unsupported_algorithm as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_decrypt_result),
            "::",
            stringify!(unsupported_algorithm)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_decrypt_result>())).recipients as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_decrypt_result),
            "::",
            stringify!(recipients)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_decrypt_result>())).file_name as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_decrypt_result),
            "::",
            stringify!(file_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_decrypt_result>())).session_key as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_decrypt_result),
            "::",
            stringify!(session_key)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_decrypt_result>())).symkey_algo as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_decrypt_result),
            "::",
            stringify!(symkey_algo)
        )
    );
}
impl _gpgme_op_decrypt_result {
    #[inline]
    pub fn wrong_key_usage(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_wrong_key_usage(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_de_vs(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_de_vs(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_mime(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_mime(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn legacy_cipher_nomdc(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_legacy_cipher_nomdc(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn _unused(&self) -> ::std::os::raw::c_int {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 28u8) as u32) }
    }
    #[inline]
    pub fn set__unused(&mut self, val: ::std::os::raw::c_int) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 28u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        wrong_key_usage: ::std::os::raw::c_uint,
        is_de_vs: ::std::os::raw::c_uint,
        is_mime: ::std::os::raw::c_uint,
        legacy_cipher_nomdc: ::std::os::raw::c_uint,
        _unused: ::std::os::raw::c_int,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let wrong_key_usage: u32 = unsafe { ::std::mem::transmute(wrong_key_usage) };
            wrong_key_usage as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_de_vs: u32 = unsafe { ::std::mem::transmute(is_de_vs) };
            is_de_vs as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let is_mime: u32 = unsafe { ::std::mem::transmute(is_mime) };
            is_mime as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let legacy_cipher_nomdc: u32 = unsafe { ::std::mem::transmute(legacy_cipher_nomdc) };
            legacy_cipher_nomdc as u64
        });
        __bindgen_bitfield_unit.set(4usize, 28u8, {
            let _unused: u32 = unsafe { ::std::mem::transmute(_unused) };
            _unused as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type gpgme_decrypt_result_t = *mut _gpgme_op_decrypt_result;
pub type gpgme_op_decrypt_result = unsafe extern "C" fn(ctx: gpgme_ctx_t) -> gpgme_decrypt_result_t;
pub const gpgme_decrypt_flags_t_GPGME_DECRYPT_VERIFY: gpgme_decrypt_flags_t = 1;
pub const gpgme_decrypt_flags_t_GPGME_DECRYPT_UNWRAP: gpgme_decrypt_flags_t = 128;
pub type gpgme_decrypt_flags_t = u32;
pub type gpgme_op_decrypt_start = unsafe extern "C" fn(
    ctx: gpgme_ctx_t,
    cipher: gpgme_data_t,
    plain: gpgme_data_t,
) -> gpgme_error_t;
extern "C" {
    pub fn gpgme_op_decrypt(
        ctx: gpgme_ctx_t,
        cipher: gpgme_data_t,
        plain: gpgme_data_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_decrypt_verify_start(
        ctx: gpgme_ctx_t,
        cipher: gpgme_data_t,
        plain: gpgme_data_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_decrypt_verify(
        ctx: gpgme_ctx_t,
        cipher: gpgme_data_t,
        plain: gpgme_data_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_decrypt_ext_start(
        ctx: gpgme_ctx_t,
        flags: gpgme_decrypt_flags_t,
        cipher: gpgme_data_t,
        plain: gpgme_data_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_decrypt_ext(
        ctx: gpgme_ctx_t,
        flags: gpgme_decrypt_flags_t,
        cipher: gpgme_data_t,
        plain: gpgme_data_t,
    ) -> gpgme_error_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_new_signature {
    pub next: *mut _gpgme_new_signature,
    pub type_: gpgme_sig_mode_t,
    pub pubkey_algo: gpgme_pubkey_algo_t,
    pub hash_algo: gpgme_hash_algo_t,
    pub _obsolete_class: ::std::os::raw::c_ulong,
    pub timestamp: ::std::os::raw::c_long,
    pub fpr: *mut ::std::os::raw::c_char,
    pub class: ::std::os::raw::c_uint,
    pub sig_class: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout__gpgme_new_signature() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_new_signature>(),
        56usize,
        concat!("Size of: ", stringify!(_gpgme_new_signature))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_new_signature>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_new_signature))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_new_signature>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_new_signature),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_new_signature>())).type_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_new_signature),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_new_signature>())).pubkey_algo as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_new_signature),
            "::",
            stringify!(pubkey_algo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_new_signature>())).hash_algo as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_new_signature),
            "::",
            stringify!(hash_algo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_new_signature>()))._obsolete_class as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_new_signature),
            "::",
            stringify!(_obsolete_class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_new_signature>())).timestamp as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_new_signature),
            "::",
            stringify!(timestamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_new_signature>())).fpr as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_new_signature),
            "::",
            stringify!(fpr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_new_signature>())).class as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_new_signature),
            "::",
            stringify!(class)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_new_signature>())).sig_class as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_new_signature),
            "::",
            stringify!(sig_class)
        )
    );
}
pub type gpgme_new_signature_t = *mut _gpgme_new_signature;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_op_sign_result {
    pub invalid_signers: gpgme_invalid_key_t,
    pub signatures: gpgme_new_signature_t,
}
#[test]
fn bindgen_test_layout__gpgme_op_sign_result() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_op_sign_result>(),
        16usize,
        concat!("Size of: ", stringify!(_gpgme_op_sign_result))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_op_sign_result>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_op_sign_result))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_sign_result>())).invalid_signers as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_sign_result),
            "::",
            stringify!(invalid_signers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_sign_result>())).signatures as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_sign_result),
            "::",
            stringify!(signatures)
        )
    );
}
pub type gpgme_sign_result_t = *mut _gpgme_op_sign_result;
extern "C" {
    pub fn gpgme_op_sign_result(ctx: gpgme_ctx_t) -> gpgme_sign_result_t;
}
pub type gpgme_op_sign_start = unsafe extern "C" fn(
    ctx: gpgme_ctx_t,
    plain: gpgme_data_t,
    sig: gpgme_data_t,
    mode: gpgme_sig_mode_t,
) -> gpgme_error_t;
extern "C" {
    pub fn gpgme_op_sign(
        ctx: gpgme_ctx_t,
        plain: gpgme_data_t,
        sig: gpgme_data_t,
        mode: gpgme_sig_mode_t,
    ) -> gpgme_error_t;
}
pub const gpgme_sigsum_t_GPGME_SIGSUM_VALID: gpgme_sigsum_t = 1;
pub const gpgme_sigsum_t_GPGME_SIGSUM_GREEN: gpgme_sigsum_t = 2;
pub const gpgme_sigsum_t_GPGME_SIGSUM_RED: gpgme_sigsum_t = 4;
pub const gpgme_sigsum_t_GPGME_SIGSUM_KEY_REVOKED: gpgme_sigsum_t = 16;
pub const gpgme_sigsum_t_GPGME_SIGSUM_KEY_EXPIRED: gpgme_sigsum_t = 32;
pub const gpgme_sigsum_t_GPGME_SIGSUM_SIG_EXPIRED: gpgme_sigsum_t = 64;
pub const gpgme_sigsum_t_GPGME_SIGSUM_KEY_MISSING: gpgme_sigsum_t = 128;
pub const gpgme_sigsum_t_GPGME_SIGSUM_CRL_MISSING: gpgme_sigsum_t = 256;
pub const gpgme_sigsum_t_GPGME_SIGSUM_CRL_TOO_OLD: gpgme_sigsum_t = 512;
pub const gpgme_sigsum_t_GPGME_SIGSUM_BAD_POLICY: gpgme_sigsum_t = 1024;
pub const gpgme_sigsum_t_GPGME_SIGSUM_SYS_ERROR: gpgme_sigsum_t = 2048;
pub const gpgme_sigsum_t_GPGME_SIGSUM_TOFU_CONFLICT: gpgme_sigsum_t = 4096;
pub type gpgme_sigsum_t = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_signature {
    pub next: *mut _gpgme_signature,
    pub summary: gpgme_sigsum_t,
    pub fpr: *mut ::std::os::raw::c_char,
    pub status: gpgme_error_t,
    pub notations: gpgme_sig_notation_t,
    pub timestamp: ::std::os::raw::c_ulong,
    pub exp_timestamp: ::std::os::raw::c_ulong,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub validity: gpgme_validity_t,
    pub validity_reason: gpgme_error_t,
    pub pubkey_algo: gpgme_pubkey_algo_t,
    pub hash_algo: gpgme_hash_algo_t,
    pub pka_address: *mut ::std::os::raw::c_char,
    pub key: gpgme_key_t,
}
#[test]
fn bindgen_test_layout__gpgme_signature() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_signature>(),
        96usize,
        concat!("Size of: ", stringify!(_gpgme_signature))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_signature>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_signature))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_signature>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_signature),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_signature>())).summary as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_signature),
            "::",
            stringify!(summary)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_signature>())).fpr as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_signature),
            "::",
            stringify!(fpr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_signature>())).status as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_signature),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_signature>())).notations as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_signature),
            "::",
            stringify!(notations)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_signature>())).timestamp as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_signature),
            "::",
            stringify!(timestamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_signature>())).exp_timestamp as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_signature),
            "::",
            stringify!(exp_timestamp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_signature>())).validity as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_signature),
            "::",
            stringify!(validity)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_signature>())).validity_reason as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_signature),
            "::",
            stringify!(validity_reason)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_signature>())).pubkey_algo as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_signature),
            "::",
            stringify!(pubkey_algo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_signature>())).hash_algo as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_signature),
            "::",
            stringify!(hash_algo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_signature>())).pka_address as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_signature),
            "::",
            stringify!(pka_address)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_signature>())).key as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_signature),
            "::",
            stringify!(key)
        )
    );
}
impl _gpgme_signature {
    #[inline]
    pub fn wrong_key_usage(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_wrong_key_usage(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pka_trust(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_pka_trust(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn chain_model(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_chain_model(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_de_vs(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_de_vs(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn _unused(&self) -> ::std::os::raw::c_int {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 27u8) as u32) }
    }
    #[inline]
    pub fn set__unused(&mut self, val: ::std::os::raw::c_int) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 27u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        wrong_key_usage: ::std::os::raw::c_uint,
        pka_trust: ::std::os::raw::c_uint,
        chain_model: ::std::os::raw::c_uint,
        is_de_vs: ::std::os::raw::c_uint,
        _unused: ::std::os::raw::c_int,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let wrong_key_usage: u32 = unsafe { ::std::mem::transmute(wrong_key_usage) };
            wrong_key_usage as u64
        });
        __bindgen_bitfield_unit.set(1usize, 2u8, {
            let pka_trust: u32 = unsafe { ::std::mem::transmute(pka_trust) };
            pka_trust as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let chain_model: u32 = unsafe { ::std::mem::transmute(chain_model) };
            chain_model as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let is_de_vs: u32 = unsafe { ::std::mem::transmute(is_de_vs) };
            is_de_vs as u64
        });
        __bindgen_bitfield_unit.set(5usize, 27u8, {
            let _unused: u32 = unsafe { ::std::mem::transmute(_unused) };
            _unused as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type gpgme_signature_t = *mut _gpgme_signature;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_op_verify_result {
    pub signatures: gpgme_signature_t,
    pub file_name: *mut ::std::os::raw::c_char,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub __bindgen_padding_0: u32,
}
#[test]
fn bindgen_test_layout__gpgme_op_verify_result() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_op_verify_result>(),
        24usize,
        concat!("Size of: ", stringify!(_gpgme_op_verify_result))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_op_verify_result>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_op_verify_result))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_verify_result>())).signatures as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_verify_result),
            "::",
            stringify!(signatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_verify_result>())).file_name as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_verify_result),
            "::",
            stringify!(file_name)
        )
    );
}
impl _gpgme_op_verify_result {
    #[inline]
    pub fn is_mime(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_mime(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn _unused(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 31u8) as u32) }
    }
    #[inline]
    pub fn set__unused(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 31u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        is_mime: ::std::os::raw::c_uint,
        _unused: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let is_mime: u32 = unsafe { ::std::mem::transmute(is_mime) };
            is_mime as u64
        });
        __bindgen_bitfield_unit.set(1usize, 31u8, {
            let _unused: u32 = unsafe { ::std::mem::transmute(_unused) };
            _unused as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type gpgme_verify_result_t = *mut _gpgme_op_verify_result;
pub type gpgme_op_verify_result = unsafe extern "C" fn(ctx: gpgme_ctx_t) -> gpgme_verify_result_t;
pub type gpgme_op_verify_start = unsafe extern "C" fn(
    ctx: gpgme_ctx_t,
    sig: gpgme_data_t,
    signed_text: gpgme_data_t,
    plaintext: gpgme_data_t,
) -> gpgme_error_t;
extern "C" {
    pub fn gpgme_op_verify(
        ctx: gpgme_ctx_t,
        sig: gpgme_data_t,
        signed_text: gpgme_data_t,
        plaintext: gpgme_data_t,
    ) -> gpgme_error_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_import_status {
    pub next: *mut _gpgme_import_status,
    pub fpr: *mut ::std::os::raw::c_char,
    pub result: gpgme_error_t,
    pub status: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout__gpgme_import_status() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_import_status>(),
        24usize,
        concat!("Size of: ", stringify!(_gpgme_import_status))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_import_status>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_import_status))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_import_status>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_import_status),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_import_status>())).fpr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_import_status),
            "::",
            stringify!(fpr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_import_status>())).result as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_import_status),
            "::",
            stringify!(result)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_import_status>())).status as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_import_status),
            "::",
            stringify!(status)
        )
    );
}
pub type gpgme_import_status_t = *mut _gpgme_import_status;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_op_import_result {
    pub considered: ::std::os::raw::c_int,
    pub no_user_id: ::std::os::raw::c_int,
    pub imported: ::std::os::raw::c_int,
    pub imported_rsa: ::std::os::raw::c_int,
    pub unchanged: ::std::os::raw::c_int,
    pub new_user_ids: ::std::os::raw::c_int,
    pub new_sub_keys: ::std::os::raw::c_int,
    pub new_signatures: ::std::os::raw::c_int,
    pub new_revocations: ::std::os::raw::c_int,
    pub secret_read: ::std::os::raw::c_int,
    pub secret_imported: ::std::os::raw::c_int,
    pub secret_unchanged: ::std::os::raw::c_int,
    pub skipped_new_keys: ::std::os::raw::c_int,
    pub not_imported: ::std::os::raw::c_int,
    pub imports: gpgme_import_status_t,
    pub skipped_v3_keys: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout__gpgme_op_import_result() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_op_import_result>(),
        72usize,
        concat!("Size of: ", stringify!(_gpgme_op_import_result))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_op_import_result>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_op_import_result))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_import_result>())).considered as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_import_result),
            "::",
            stringify!(considered)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_import_result>())).no_user_id as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_import_result),
            "::",
            stringify!(no_user_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_import_result>())).imported as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_import_result),
            "::",
            stringify!(imported)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_import_result>())).imported_rsa as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_import_result),
            "::",
            stringify!(imported_rsa)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_import_result>())).unchanged as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_import_result),
            "::",
            stringify!(unchanged)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_import_result>())).new_user_ids as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_import_result),
            "::",
            stringify!(new_user_ids)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_import_result>())).new_sub_keys as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_import_result),
            "::",
            stringify!(new_sub_keys)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_import_result>())).new_signatures as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_import_result),
            "::",
            stringify!(new_signatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_import_result>())).new_revocations as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_import_result),
            "::",
            stringify!(new_revocations)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_import_result>())).secret_read as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_import_result),
            "::",
            stringify!(secret_read)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_import_result>())).secret_imported as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_import_result),
            "::",
            stringify!(secret_imported)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_import_result>())).secret_unchanged as *const _
                as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_import_result),
            "::",
            stringify!(secret_unchanged)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_import_result>())).skipped_new_keys as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_import_result),
            "::",
            stringify!(skipped_new_keys)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_import_result>())).not_imported as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_import_result),
            "::",
            stringify!(not_imported)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_op_import_result>())).imports as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_import_result),
            "::",
            stringify!(imports)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_import_result>())).skipped_v3_keys as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_import_result),
            "::",
            stringify!(skipped_v3_keys)
        )
    );
}
pub type gpgme_import_result_t = *mut _gpgme_op_import_result;
extern "C" {
    pub fn gpgme_op_import_result(ctx: gpgme_ctx_t) -> gpgme_import_result_t;
}
extern "C" {
    pub fn gpgme_op_import_start(ctx: gpgme_ctx_t, keydata: gpgme_data_t) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_import(ctx: gpgme_ctx_t, keydata: gpgme_data_t) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_import_keys_start(ctx: gpgme_ctx_t, keys: *mut gpgme_key_t) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_import_keys(ctx: gpgme_ctx_t, keys: *mut gpgme_key_t) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_export_start(
        ctx: gpgme_ctx_t,
        pattern: *const ::std::os::raw::c_char,
        mode: gpgme_export_mode_t,
        keydata: gpgme_data_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_export(
        ctx: gpgme_ctx_t,
        pattern: *const ::std::os::raw::c_char,
        mode: gpgme_export_mode_t,
        keydata: gpgme_data_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_export_ext_start(
        ctx: gpgme_ctx_t,
        pattern: *mut *const ::std::os::raw::c_char,
        mode: gpgme_export_mode_t,
        keydata: gpgme_data_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_export_ext(
        ctx: gpgme_ctx_t,
        pattern: *mut *const ::std::os::raw::c_char,
        mode: gpgme_export_mode_t,
        keydata: gpgme_data_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_export_keys_start(
        ctx: gpgme_ctx_t,
        keys: *mut gpgme_key_t,
        mode: gpgme_export_mode_t,
        keydata: gpgme_data_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_export_keys(
        ctx: gpgme_ctx_t,
        keys: *mut gpgme_key_t,
        mode: gpgme_export_mode_t,
        keydata: gpgme_data_t,
    ) -> gpgme_error_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_op_genkey_result {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub fpr: *mut ::std::os::raw::c_char,
    pub pubkey: gpgme_data_t,
    pub seckey: gpgme_data_t,
}
#[test]
fn bindgen_test_layout__gpgme_op_genkey_result() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_op_genkey_result>(),
        32usize,
        concat!("Size of: ", stringify!(_gpgme_op_genkey_result))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_op_genkey_result>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_op_genkey_result))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_op_genkey_result>())).fpr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_genkey_result),
            "::",
            stringify!(fpr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_op_genkey_result>())).pubkey as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_genkey_result),
            "::",
            stringify!(pubkey)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_op_genkey_result>())).seckey as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_genkey_result),
            "::",
            stringify!(seckey)
        )
    );
}
impl _gpgme_op_genkey_result {
    #[inline]
    pub fn primary(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_primary(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sub(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sub(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn uid(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_uid(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn _unused(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 29u8) as u32) }
    }
    #[inline]
    pub fn set__unused(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 29u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        primary: ::std::os::raw::c_uint,
        sub: ::std::os::raw::c_uint,
        uid: ::std::os::raw::c_uint,
        _unused: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let primary: u32 = unsafe { ::std::mem::transmute(primary) };
            primary as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let sub: u32 = unsafe { ::std::mem::transmute(sub) };
            sub as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let uid: u32 = unsafe { ::std::mem::transmute(uid) };
            uid as u64
        });
        __bindgen_bitfield_unit.set(3usize, 29u8, {
            let _unused: u32 = unsafe { ::std::mem::transmute(_unused) };
            _unused as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type gpgme_genkey_result_t = *mut _gpgme_op_genkey_result;
extern "C" {
    pub fn gpgme_op_genkey_start(
        ctx: gpgme_ctx_t,
        parms: *const ::std::os::raw::c_char,
        pubkey: gpgme_data_t,
        seckey: gpgme_data_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_genkey(
        ctx: gpgme_ctx_t,
        parms: *const ::std::os::raw::c_char,
        pubkey: gpgme_data_t,
        seckey: gpgme_data_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_createkey_start(
        ctx: gpgme_ctx_t,
        userid: *const ::std::os::raw::c_char,
        algo: *const ::std::os::raw::c_char,
        reserved: ::std::os::raw::c_ulong,
        expires: ::std::os::raw::c_ulong,
        certkey: gpgme_key_t,
        flags: ::std::os::raw::c_uint,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_createkey(
        ctx: gpgme_ctx_t,
        userid: *const ::std::os::raw::c_char,
        algo: *const ::std::os::raw::c_char,
        reserved: ::std::os::raw::c_ulong,
        expires: ::std::os::raw::c_ulong,
        certkey: gpgme_key_t,
        flags: ::std::os::raw::c_uint,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_createsubkey_start(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        algo: *const ::std::os::raw::c_char,
        reserved: ::std::os::raw::c_ulong,
        expires: ::std::os::raw::c_ulong,
        flags: ::std::os::raw::c_uint,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_createsubkey(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        algo: *const ::std::os::raw::c_char,
        reserved: ::std::os::raw::c_ulong,
        expires: ::std::os::raw::c_ulong,
        flags: ::std::os::raw::c_uint,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_adduid_start(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        userid: *const ::std::os::raw::c_char,
        reserved: ::std::os::raw::c_uint,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_adduid(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        userid: *const ::std::os::raw::c_char,
        reserved: ::std::os::raw::c_uint,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_revuid_start(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        userid: *const ::std::os::raw::c_char,
        reserved: ::std::os::raw::c_uint,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_revuid(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        userid: *const ::std::os::raw::c_char,
        reserved: ::std::os::raw::c_uint,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_set_uid_flag_start(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        userid: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_set_uid_flag(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        userid: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_genkey_result(ctx: gpgme_ctx_t) -> gpgme_genkey_result_t;
}
extern "C" {
    pub fn gpgme_op_delete_start(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        allow_secret: ::std::os::raw::c_int,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_delete(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        allow_secret: ::std::os::raw::c_int,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_delete_ext_start(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        flags: ::std::os::raw::c_uint,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_delete_ext(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        flags: ::std::os::raw::c_uint,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_keysign_start(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        userid: *const ::std::os::raw::c_char,
        expires: ::std::os::raw::c_ulong,
        flags: ::std::os::raw::c_uint,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_keysign(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        userid: *const ::std::os::raw::c_char,
        expires: ::std::os::raw::c_ulong,
        flags: ::std::os::raw::c_uint,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_interact_start(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        flags: ::std::os::raw::c_uint,
        fnc: gpgme_interact_cb_t,
        fnc_value: *mut ::std::os::raw::c_void,
        out: gpgme_data_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_interact(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        flags: ::std::os::raw::c_uint,
        fnc: gpgme_interact_cb_t,
        fnc_value: *mut ::std::os::raw::c_void,
        out: gpgme_data_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_tofu_policy_start(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        policy: gpgme_tofu_policy_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_tofu_policy(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        policy: gpgme_tofu_policy_t,
    ) -> gpgme_error_t;
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_op_keylist_result {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
}
#[test]
fn bindgen_test_layout__gpgme_op_keylist_result() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_op_keylist_result>(),
        4usize,
        concat!("Size of: ", stringify!(_gpgme_op_keylist_result))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_op_keylist_result>(),
        4usize,
        concat!("Alignment of ", stringify!(_gpgme_op_keylist_result))
    );
}
impl _gpgme_op_keylist_result {
    #[inline]
    pub fn truncated(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_truncated(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn _unused(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 31u8) as u32) }
    }
    #[inline]
    pub fn set__unused(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 31u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        truncated: ::std::os::raw::c_uint,
        _unused: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let truncated: u32 = unsafe { ::std::mem::transmute(truncated) };
            truncated as u64
        });
        __bindgen_bitfield_unit.set(1usize, 31u8, {
            let _unused: u32 = unsafe { ::std::mem::transmute(_unused) };
            _unused as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type gpgme_keylist_result_t = *mut _gpgme_op_keylist_result;
extern "C" {
    pub fn gpgme_op_keylist_result(ctx: gpgme_ctx_t) -> gpgme_keylist_result_t;
}
pub type gpgme_op_keylist_start = unsafe extern "C" fn(
    ctx: gpgme_ctx_t,
    pattern: *const ::std::os::raw::c_char,
    secret_only: ::std::os::raw::c_int,
) -> gpgme_error_t;
extern "C" {
    pub fn gpgme_op_keylist_ext_start(
        ctx: gpgme_ctx_t,
        pattern: *mut *const ::std::os::raw::c_char,
        secret_only: ::std::os::raw::c_int,
        reserved: ::std::os::raw::c_int,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_keylist_from_data_start(
        ctx: gpgme_ctx_t,
        data: gpgme_data_t,
        reserved: ::std::os::raw::c_int,
    ) -> gpgme_error_t;
}
pub type gpgme_op_keylist_next =
    unsafe extern "C" fn(ctx: gpgme_ctx_t, r_key: *mut gpgme_key_t) -> gpgme_error_t;
pub type gpgme_op_keylist_end = unsafe extern "C" fn(ctx: gpgme_ctx_t) -> gpgme_error_t;
extern "C" {
    pub fn gpgme_op_passwd_start(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        flags: ::std::os::raw::c_uint,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_passwd(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        flags: ::std::os::raw::c_uint,
    ) -> gpgme_error_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_trust_item {
    pub _refs: ::std::os::raw::c_uint,
    pub keyid: *mut ::std::os::raw::c_char,
    pub _keyid: [::std::os::raw::c_char; 17usize],
    pub type_: ::std::os::raw::c_int,
    pub level: ::std::os::raw::c_int,
    pub owner_trust: *mut ::std::os::raw::c_char,
    pub _owner_trust: [::std::os::raw::c_char; 2usize],
    pub validity: *mut ::std::os::raw::c_char,
    pub _validity: [::std::os::raw::c_char; 2usize],
    pub name: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__gpgme_trust_item() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_trust_item>(),
        88usize,
        concat!("Size of: ", stringify!(_gpgme_trust_item))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_trust_item>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_trust_item))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_trust_item>()))._refs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_trust_item),
            "::",
            stringify!(_refs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_trust_item>())).keyid as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_trust_item),
            "::",
            stringify!(keyid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_trust_item>()))._keyid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_trust_item),
            "::",
            stringify!(_keyid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_trust_item>())).type_ as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_trust_item),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_trust_item>())).level as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_trust_item),
            "::",
            stringify!(level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_trust_item>())).owner_trust as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_trust_item),
            "::",
            stringify!(owner_trust)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_trust_item>()))._owner_trust as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_trust_item),
            "::",
            stringify!(_owner_trust)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_trust_item>())).validity as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_trust_item),
            "::",
            stringify!(validity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_trust_item>()))._validity as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_trust_item),
            "::",
            stringify!(_validity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_trust_item>())).name as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_trust_item),
            "::",
            stringify!(name)
        )
    );
}
pub type gpgme_trust_item_t = *mut _gpgme_trust_item;
extern "C" {
    pub fn gpgme_op_trustlist_start(
        ctx: gpgme_ctx_t,
        pattern: *const ::std::os::raw::c_char,
        max_level: ::std::os::raw::c_int,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_trustlist_next(
        ctx: gpgme_ctx_t,
        r_item: *mut gpgme_trust_item_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_trustlist_end(ctx: gpgme_ctx_t) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_trust_item_ref(item: gpgme_trust_item_t);
}
extern "C" {
    pub fn gpgme_trust_item_unref(item: gpgme_trust_item_t);
}
extern "C" {
    pub fn gpgme_op_getauditlog_start(
        ctx: gpgme_ctx_t,
        output: gpgme_data_t,
        flags: ::std::os::raw::c_uint,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_getauditlog(
        ctx: gpgme_ctx_t,
        output: gpgme_data_t,
        flags: ::std::os::raw::c_uint,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_spawn_start(
        ctx: gpgme_ctx_t,
        file: *const ::std::os::raw::c_char,
        argv: *mut *const ::std::os::raw::c_char,
        datain: gpgme_data_t,
        dataout: gpgme_data_t,
        dataerr: gpgme_data_t,
        flags: ::std::os::raw::c_uint,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_spawn(
        ctx: gpgme_ctx_t,
        file: *const ::std::os::raw::c_char,
        argv: *mut *const ::std::os::raw::c_char,
        datain: gpgme_data_t,
        dataout: gpgme_data_t,
        dataerr: gpgme_data_t,
        flags: ::std::os::raw::c_uint,
    ) -> gpgme_error_t;
}
pub type gpgme_assuan_data_cb_t = ::std::option::Option<
    unsafe extern "C" fn(
        opaque: *mut ::std::os::raw::c_void,
        data: *const ::std::os::raw::c_void,
        datalen: usize,
    ) -> gpgme_error_t,
>;
pub type gpgme_assuan_inquire_cb_t = ::std::option::Option<
    unsafe extern "C" fn(
        opaque: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        args: *const ::std::os::raw::c_char,
        r_data: *mut gpgme_data_t,
    ) -> gpgme_error_t,
>;
pub type gpgme_assuan_status_cb_t = ::std::option::Option<
    unsafe extern "C" fn(
        opaque: *mut ::std::os::raw::c_void,
        status: *const ::std::os::raw::c_char,
        args: *const ::std::os::raw::c_char,
    ) -> gpgme_error_t,
>;
extern "C" {
    pub fn gpgme_op_assuan_transact_start(
        ctx: gpgme_ctx_t,
        command: *const ::std::os::raw::c_char,
        data_cb: gpgme_assuan_data_cb_t,
        data_cb_value: *mut ::std::os::raw::c_void,
        inq_cb: gpgme_assuan_inquire_cb_t,
        inq_cb_value: *mut ::std::os::raw::c_void,
        stat_cb: gpgme_assuan_status_cb_t,
        stat_cb_value: *mut ::std::os::raw::c_void,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_assuan_transact_ext(
        ctx: gpgme_ctx_t,
        command: *const ::std::os::raw::c_char,
        data_cb: gpgme_assuan_data_cb_t,
        data_cb_value: *mut ::std::os::raw::c_void,
        inq_cb: gpgme_assuan_inquire_cb_t,
        inq_cb_value: *mut ::std::os::raw::c_void,
        stat_cb: gpgme_assuan_status_cb_t,
        stat_cb_value: *mut ::std::os::raw::c_void,
        op_err: *mut gpgme_error_t,
    ) -> gpgme_error_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_op_vfs_mount_result {
    pub mount_dir: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__gpgme_op_vfs_mount_result() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_op_vfs_mount_result>(),
        8usize,
        concat!("Size of: ", stringify!(_gpgme_op_vfs_mount_result))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_op_vfs_mount_result>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_op_vfs_mount_result))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_vfs_mount_result>())).mount_dir as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_vfs_mount_result),
            "::",
            stringify!(mount_dir)
        )
    );
}
pub type gpgme_vfs_mount_result_t = *mut _gpgme_op_vfs_mount_result;
extern "C" {
    pub fn gpgme_op_vfs_mount_result(ctx: gpgme_ctx_t) -> gpgme_vfs_mount_result_t;
}
extern "C" {
    pub fn gpgme_op_vfs_mount(
        ctx: gpgme_ctx_t,
        container_file: *const ::std::os::raw::c_char,
        mount_dir: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_uint,
        op_err: *mut gpgme_error_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_vfs_create(
        ctx: gpgme_ctx_t,
        recp: *mut gpgme_key_t,
        container_file: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_uint,
        op_err: *mut gpgme_error_t,
    ) -> gpgme_error_t;
}
pub const gpgme_conf_level_t_GPGME_CONF_BASIC: gpgme_conf_level_t = 0;
pub const gpgme_conf_level_t_GPGME_CONF_ADVANCED: gpgme_conf_level_t = 1;
pub const gpgme_conf_level_t_GPGME_CONF_EXPERT: gpgme_conf_level_t = 2;
pub const gpgme_conf_level_t_GPGME_CONF_INVISIBLE: gpgme_conf_level_t = 3;
pub const gpgme_conf_level_t_GPGME_CONF_INTERNAL: gpgme_conf_level_t = 4;
pub type gpgme_conf_level_t = u32;
pub const gpgme_conf_type_t_GPGME_CONF_NONE: gpgme_conf_type_t = 0;
pub const gpgme_conf_type_t_GPGME_CONF_STRING: gpgme_conf_type_t = 1;
pub const gpgme_conf_type_t_GPGME_CONF_INT32: gpgme_conf_type_t = 2;
pub const gpgme_conf_type_t_GPGME_CONF_UINT32: gpgme_conf_type_t = 3;
pub const gpgme_conf_type_t_GPGME_CONF_FILENAME: gpgme_conf_type_t = 32;
pub const gpgme_conf_type_t_GPGME_CONF_LDAP_SERVER: gpgme_conf_type_t = 33;
pub const gpgme_conf_type_t_GPGME_CONF_KEY_FPR: gpgme_conf_type_t = 34;
pub const gpgme_conf_type_t_GPGME_CONF_PUB_KEY: gpgme_conf_type_t = 35;
pub const gpgme_conf_type_t_GPGME_CONF_SEC_KEY: gpgme_conf_type_t = 36;
pub const gpgme_conf_type_t_GPGME_CONF_ALIAS_LIST: gpgme_conf_type_t = 37;
pub type gpgme_conf_type_t = u32;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct gpgme_conf_arg {
    pub next: *mut gpgme_conf_arg,
    pub no_arg: ::std::os::raw::c_uint,
    pub value: gpgme_conf_arg__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union gpgme_conf_arg__bindgen_ty_1 {
    pub count: ::std::os::raw::c_uint,
    pub uint32: ::std::os::raw::c_uint,
    pub int32: ::std::os::raw::c_int,
    pub string: *mut ::std::os::raw::c_char,
    _bindgen_union_align: u64,
}
#[test]
fn bindgen_test_layout_gpgme_conf_arg__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<gpgme_conf_arg__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(gpgme_conf_arg__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<gpgme_conf_arg__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(gpgme_conf_arg__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gpgme_conf_arg__bindgen_ty_1>())).count as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_arg__bindgen_ty_1),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gpgme_conf_arg__bindgen_ty_1>())).uint32 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_arg__bindgen_ty_1),
            "::",
            stringify!(uint32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gpgme_conf_arg__bindgen_ty_1>())).int32 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_arg__bindgen_ty_1),
            "::",
            stringify!(int32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gpgme_conf_arg__bindgen_ty_1>())).string as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_arg__bindgen_ty_1),
            "::",
            stringify!(string)
        )
    );
}
#[test]
fn bindgen_test_layout_gpgme_conf_arg() {
    assert_eq!(
        ::std::mem::size_of::<gpgme_conf_arg>(),
        24usize,
        concat!("Size of: ", stringify!(gpgme_conf_arg))
    );
    assert_eq!(
        ::std::mem::align_of::<gpgme_conf_arg>(),
        8usize,
        concat!("Alignment of ", stringify!(gpgme_conf_arg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_arg>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_arg),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_arg>())).no_arg as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_arg),
            "::",
            stringify!(no_arg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_arg>())).value as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_arg),
            "::",
            stringify!(value)
        )
    );
}
pub type gpgme_conf_arg_t = *mut gpgme_conf_arg;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpgme_conf_opt {
    pub next: *mut gpgme_conf_opt,
    pub name: *mut ::std::os::raw::c_char,
    pub flags: ::std::os::raw::c_uint,
    pub level: gpgme_conf_level_t,
    pub description: *mut ::std::os::raw::c_char,
    pub type_: gpgme_conf_type_t,
    pub alt_type: gpgme_conf_type_t,
    pub argname: *mut ::std::os::raw::c_char,
    pub default_value: gpgme_conf_arg_t,
    pub default_description: *mut ::std::os::raw::c_char,
    pub no_arg_value: gpgme_conf_arg_t,
    pub no_arg_description: *mut ::std::os::raw::c_char,
    pub value: gpgme_conf_arg_t,
    pub change_value: ::std::os::raw::c_int,
    pub new_value: gpgme_conf_arg_t,
    pub user_data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_gpgme_conf_opt() {
    assert_eq!(
        ::std::mem::size_of::<gpgme_conf_opt>(),
        112usize,
        concat!("Size of: ", stringify!(gpgme_conf_opt))
    );
    assert_eq!(
        ::std::mem::align_of::<gpgme_conf_opt>(),
        8usize,
        concat!("Alignment of ", stringify!(gpgme_conf_opt))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_opt>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_opt),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_opt>())).name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_opt),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_opt>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_opt),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_opt>())).level as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_opt),
            "::",
            stringify!(level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_opt>())).description as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_opt),
            "::",
            stringify!(description)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_opt>())).type_ as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_opt),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_opt>())).alt_type as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_opt),
            "::",
            stringify!(alt_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_opt>())).argname as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_opt),
            "::",
            stringify!(argname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_opt>())).default_value as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_opt),
            "::",
            stringify!(default_value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gpgme_conf_opt>())).default_description as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_opt),
            "::",
            stringify!(default_description)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_opt>())).no_arg_value as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_opt),
            "::",
            stringify!(no_arg_value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gpgme_conf_opt>())).no_arg_description as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_opt),
            "::",
            stringify!(no_arg_description)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_opt>())).value as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_opt),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_opt>())).change_value as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_opt),
            "::",
            stringify!(change_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_opt>())).new_value as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_opt),
            "::",
            stringify!(new_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_opt>())).user_data as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_opt),
            "::",
            stringify!(user_data)
        )
    );
}
pub type gpgme_conf_opt_t = *mut gpgme_conf_opt;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gpgme_conf_comp {
    pub next: *mut gpgme_conf_comp,
    pub _last_opt_p: *mut gpgme_conf_opt_t,
    pub name: *mut ::std::os::raw::c_char,
    pub description: *mut ::std::os::raw::c_char,
    pub program_name: *mut ::std::os::raw::c_char,
    pub options: *mut gpgme_conf_opt,
}
#[test]
fn bindgen_test_layout_gpgme_conf_comp() {
    assert_eq!(
        ::std::mem::size_of::<gpgme_conf_comp>(),
        48usize,
        concat!("Size of: ", stringify!(gpgme_conf_comp))
    );
    assert_eq!(
        ::std::mem::align_of::<gpgme_conf_comp>(),
        8usize,
        concat!("Alignment of ", stringify!(gpgme_conf_comp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_comp>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_comp),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_comp>()))._last_opt_p as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_comp),
            "::",
            stringify!(_last_opt_p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_comp>())).name as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_comp),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_comp>())).description as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_comp),
            "::",
            stringify!(description)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_comp>())).program_name as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_comp),
            "::",
            stringify!(program_name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gpgme_conf_comp>())).options as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(gpgme_conf_comp),
            "::",
            stringify!(options)
        )
    );
}
pub type gpgme_conf_comp_t = *mut gpgme_conf_comp;
extern "C" {
    pub fn gpgme_conf_arg_new(
        arg_p: *mut gpgme_conf_arg_t,
        type_: gpgme_conf_type_t,
        value: *const ::std::os::raw::c_void,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_conf_arg_release(arg: gpgme_conf_arg_t, type_: gpgme_conf_type_t);
}
extern "C" {
    pub fn gpgme_conf_opt_change(
        opt: gpgme_conf_opt_t,
        reset: ::std::os::raw::c_int,
        arg: gpgme_conf_arg_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_conf_release(conf: gpgme_conf_comp_t);
}
extern "C" {
    pub fn gpgme_op_conf_load(ctx: gpgme_ctx_t, conf_p: *mut gpgme_conf_comp_t) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_conf_save(ctx: gpgme_ctx_t, comp: gpgme_conf_comp_t) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_conf_dir(
        ctx: gpgme_ctx_t,
        what: *const ::std::os::raw::c_char,
        result: *mut *mut ::std::os::raw::c_char,
    ) -> gpgme_error_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_op_query_swdb_result {
    pub next: *mut _gpgme_op_query_swdb_result,
    pub name: *mut ::std::os::raw::c_char,
    pub iversion: *mut ::std::os::raw::c_char,
    pub created: ::std::os::raw::c_ulong,
    pub retrieved: ::std::os::raw::c_ulong,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub version: *mut ::std::os::raw::c_char,
    pub reldate: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout__gpgme_op_query_swdb_result() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_op_query_swdb_result>(),
        64usize,
        concat!("Size of: ", stringify!(_gpgme_op_query_swdb_result))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_op_query_swdb_result>(),
        8usize,
        concat!("Alignment of ", stringify!(_gpgme_op_query_swdb_result))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_query_swdb_result>())).next as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_query_swdb_result),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_query_swdb_result>())).name as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_query_swdb_result),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_query_swdb_result>())).iversion as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_query_swdb_result),
            "::",
            stringify!(iversion)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_query_swdb_result>())).created as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_query_swdb_result),
            "::",
            stringify!(created)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_query_swdb_result>())).retrieved as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_query_swdb_result),
            "::",
            stringify!(retrieved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_query_swdb_result>())).version as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_query_swdb_result),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_gpgme_op_query_swdb_result>())).reldate as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_query_swdb_result),
            "::",
            stringify!(reldate)
        )
    );
}
impl _gpgme_op_query_swdb_result {
    #[inline]
    pub fn warning(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_warning(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn update(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_update(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn urgent(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_urgent(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn noinfo(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_noinfo(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn unknown(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_unknown(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn tooold(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_tooold(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn error(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_error(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn _reserved(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 25u8) as u32) }
    }
    #[inline]
    pub fn set__reserved(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 25u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        warning: ::std::os::raw::c_uint,
        update: ::std::os::raw::c_uint,
        urgent: ::std::os::raw::c_uint,
        noinfo: ::std::os::raw::c_uint,
        unknown: ::std::os::raw::c_uint,
        tooold: ::std::os::raw::c_uint,
        error: ::std::os::raw::c_uint,
        _reserved: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let warning: u32 = unsafe { ::std::mem::transmute(warning) };
            warning as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let update: u32 = unsafe { ::std::mem::transmute(update) };
            update as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let urgent: u32 = unsafe { ::std::mem::transmute(urgent) };
            urgent as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let noinfo: u32 = unsafe { ::std::mem::transmute(noinfo) };
            noinfo as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let unknown: u32 = unsafe { ::std::mem::transmute(unknown) };
            unknown as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let tooold: u32 = unsafe { ::std::mem::transmute(tooold) };
            tooold as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let error: u32 = unsafe { ::std::mem::transmute(error) };
            error as u64
        });
        __bindgen_bitfield_unit.set(7usize, 25u8, {
            let _reserved: u32 = unsafe { ::std::mem::transmute(_reserved) };
            _reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type gpgme_query_swdb_result_t = *mut _gpgme_op_query_swdb_result;
extern "C" {
    pub fn gpgme_op_query_swdb(
        ctx: gpgme_ctx_t,
        name: *const ::std::os::raw::c_char,
        iversion: *const ::std::os::raw::c_char,
        reserved: ::std::os::raw::c_uint,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_query_swdb_result(ctx: gpgme_ctx_t) -> gpgme_query_swdb_result_t;
}
extern "C" {
    pub fn gpgme_set_global_flag(
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
pub type gpgme_check_version = unsafe extern "C" fn(
    req_version: *const ::std::os::raw::c_char,
) -> *const ::std::os::raw::c_char;
extern "C" {
    pub fn gpgme_check_version_internal(
        req_version: *const ::std::os::raw::c_char,
        offset_sig_validity: usize,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn gpgme_get_dirinfo(what: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn gpgme_get_engine_info(engine_info: *mut gpgme_engine_info_t) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_set_engine_info(
        proto: gpgme_protocol_t,
        file_name: *const ::std::os::raw::c_char,
        home_dir: *const ::std::os::raw::c_char,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_engine_check_version(proto: gpgme_protocol_t) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_result_ref(result: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn gpgme_result_unref(result: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn gpgme_pubkey_algo_string(subkey: gpgme_subkey_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gpgme_pubkey_algo_name(algo: gpgme_pubkey_algo_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn gpgme_hash_algo_name(algo: gpgme_hash_algo_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn gpgme_addrspec_from_uid(
        uid: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
pub const gpgme_status_code_t_GPGME_STATUS_EOF: gpgme_status_code_t = 0;
pub const gpgme_status_code_t_GPGME_STATUS_ENTER: gpgme_status_code_t = 1;
pub const gpgme_status_code_t_GPGME_STATUS_LEAVE: gpgme_status_code_t = 2;
pub const gpgme_status_code_t_GPGME_STATUS_ABORT: gpgme_status_code_t = 3;
pub const gpgme_status_code_t_GPGME_STATUS_GOODSIG: gpgme_status_code_t = 4;
pub const gpgme_status_code_t_GPGME_STATUS_BADSIG: gpgme_status_code_t = 5;
pub const gpgme_status_code_t_GPGME_STATUS_ERRSIG: gpgme_status_code_t = 6;
pub const gpgme_status_code_t_GPGME_STATUS_BADARMOR: gpgme_status_code_t = 7;
pub const gpgme_status_code_t_GPGME_STATUS_RSA_OR_IDEA: gpgme_status_code_t = 8;
pub const gpgme_status_code_t_GPGME_STATUS_KEYEXPIRED: gpgme_status_code_t = 9;
pub const gpgme_status_code_t_GPGME_STATUS_KEYREVOKED: gpgme_status_code_t = 10;
pub const gpgme_status_code_t_GPGME_STATUS_TRUST_UNDEFINED: gpgme_status_code_t = 11;
pub const gpgme_status_code_t_GPGME_STATUS_TRUST_NEVER: gpgme_status_code_t = 12;
pub const gpgme_status_code_t_GPGME_STATUS_TRUST_MARGINAL: gpgme_status_code_t = 13;
pub const gpgme_status_code_t_GPGME_STATUS_TRUST_FULLY: gpgme_status_code_t = 14;
pub const gpgme_status_code_t_GPGME_STATUS_TRUST_ULTIMATE: gpgme_status_code_t = 15;
pub const gpgme_status_code_t_GPGME_STATUS_SHM_INFO: gpgme_status_code_t = 16;
pub const gpgme_status_code_t_GPGME_STATUS_SHM_GET: gpgme_status_code_t = 17;
pub const gpgme_status_code_t_GPGME_STATUS_SHM_GET_BOOL: gpgme_status_code_t = 18;
pub const gpgme_status_code_t_GPGME_STATUS_SHM_GET_HIDDEN: gpgme_status_code_t = 19;
pub const gpgme_status_code_t_GPGME_STATUS_NEED_PASSPHRASE: gpgme_status_code_t = 20;
pub const gpgme_status_code_t_GPGME_STATUS_VALIDSIG: gpgme_status_code_t = 21;
pub const gpgme_status_code_t_GPGME_STATUS_SIG_ID: gpgme_status_code_t = 22;
pub const gpgme_status_code_t_GPGME_STATUS_ENC_TO: gpgme_status_code_t = 23;
pub const gpgme_status_code_t_GPGME_STATUS_NODATA: gpgme_status_code_t = 24;
pub const gpgme_status_code_t_GPGME_STATUS_BAD_PASSPHRASE: gpgme_status_code_t = 25;
pub const gpgme_status_code_t_GPGME_STATUS_NO_PUBKEY: gpgme_status_code_t = 26;
pub const gpgme_status_code_t_GPGME_STATUS_NO_SECKEY: gpgme_status_code_t = 27;
pub const gpgme_status_code_t_GPGME_STATUS_NEED_PASSPHRASE_SYM: gpgme_status_code_t = 28;
pub const gpgme_status_code_t_GPGME_STATUS_DECRYPTION_FAILED: gpgme_status_code_t = 29;
pub const gpgme_status_code_t_GPGME_STATUS_DECRYPTION_OKAY: gpgme_status_code_t = 30;
pub const gpgme_status_code_t_GPGME_STATUS_MISSING_PASSPHRASE: gpgme_status_code_t = 31;
pub const gpgme_status_code_t_GPGME_STATUS_GOOD_PASSPHRASE: gpgme_status_code_t = 32;
pub const gpgme_status_code_t_GPGME_STATUS_GOODMDC: gpgme_status_code_t = 33;
pub const gpgme_status_code_t_GPGME_STATUS_BADMDC: gpgme_status_code_t = 34;
pub const gpgme_status_code_t_GPGME_STATUS_ERRMDC: gpgme_status_code_t = 35;
pub const gpgme_status_code_t_GPGME_STATUS_IMPORTED: gpgme_status_code_t = 36;
pub const gpgme_status_code_t_GPGME_STATUS_IMPORT_OK: gpgme_status_code_t = 37;
pub const gpgme_status_code_t_GPGME_STATUS_IMPORT_PROBLEM: gpgme_status_code_t = 38;
pub const gpgme_status_code_t_GPGME_STATUS_IMPORT_RES: gpgme_status_code_t = 39;
pub const gpgme_status_code_t_GPGME_STATUS_FILE_START: gpgme_status_code_t = 40;
pub const gpgme_status_code_t_GPGME_STATUS_FILE_DONE: gpgme_status_code_t = 41;
pub const gpgme_status_code_t_GPGME_STATUS_FILE_ERROR: gpgme_status_code_t = 42;
pub const gpgme_status_code_t_GPGME_STATUS_BEGIN_DECRYPTION: gpgme_status_code_t = 43;
pub const gpgme_status_code_t_GPGME_STATUS_END_DECRYPTION: gpgme_status_code_t = 44;
pub const gpgme_status_code_t_GPGME_STATUS_BEGIN_ENCRYPTION: gpgme_status_code_t = 45;
pub const gpgme_status_code_t_GPGME_STATUS_END_ENCRYPTION: gpgme_status_code_t = 46;
pub const gpgme_status_code_t_GPGME_STATUS_DELETE_PROBLEM: gpgme_status_code_t = 47;
pub const gpgme_status_code_t_GPGME_STATUS_GET_BOOL: gpgme_status_code_t = 48;
pub const gpgme_status_code_t_GPGME_STATUS_GET_LINE: gpgme_status_code_t = 49;
pub const gpgme_status_code_t_GPGME_STATUS_GET_HIDDEN: gpgme_status_code_t = 50;
pub const gpgme_status_code_t_GPGME_STATUS_GOT_IT: gpgme_status_code_t = 51;
pub const gpgme_status_code_t_GPGME_STATUS_PROGRESS: gpgme_status_code_t = 52;
pub const gpgme_status_code_t_GPGME_STATUS_SIG_CREATED: gpgme_status_code_t = 53;
pub const gpgme_status_code_t_GPGME_STATUS_SESSION_KEY: gpgme_status_code_t = 54;
pub const gpgme_status_code_t_GPGME_STATUS_NOTATION_NAME: gpgme_status_code_t = 55;
pub const gpgme_status_code_t_GPGME_STATUS_NOTATION_DATA: gpgme_status_code_t = 56;
pub const gpgme_status_code_t_GPGME_STATUS_POLICY_URL: gpgme_status_code_t = 57;
pub const gpgme_status_code_t_GPGME_STATUS_BEGIN_STREAM: gpgme_status_code_t = 58;
pub const gpgme_status_code_t_GPGME_STATUS_END_STREAM: gpgme_status_code_t = 59;
pub const gpgme_status_code_t_GPGME_STATUS_KEY_CREATED: gpgme_status_code_t = 60;
pub const gpgme_status_code_t_GPGME_STATUS_USERID_HINT: gpgme_status_code_t = 61;
pub const gpgme_status_code_t_GPGME_STATUS_UNEXPECTED: gpgme_status_code_t = 62;
pub const gpgme_status_code_t_GPGME_STATUS_INV_RECP: gpgme_status_code_t = 63;
pub const gpgme_status_code_t_GPGME_STATUS_NO_RECP: gpgme_status_code_t = 64;
pub const gpgme_status_code_t_GPGME_STATUS_ALREADY_SIGNED: gpgme_status_code_t = 65;
pub const gpgme_status_code_t_GPGME_STATUS_SIGEXPIRED: gpgme_status_code_t = 66;
pub const gpgme_status_code_t_GPGME_STATUS_EXPSIG: gpgme_status_code_t = 67;
pub const gpgme_status_code_t_GPGME_STATUS_EXPKEYSIG: gpgme_status_code_t = 68;
pub const gpgme_status_code_t_GPGME_STATUS_TRUNCATED: gpgme_status_code_t = 69;
pub const gpgme_status_code_t_GPGME_STATUS_ERROR: gpgme_status_code_t = 70;
pub const gpgme_status_code_t_GPGME_STATUS_NEWSIG: gpgme_status_code_t = 71;
pub const gpgme_status_code_t_GPGME_STATUS_REVKEYSIG: gpgme_status_code_t = 72;
pub const gpgme_status_code_t_GPGME_STATUS_SIG_SUBPACKET: gpgme_status_code_t = 73;
pub const gpgme_status_code_t_GPGME_STATUS_NEED_PASSPHRASE_PIN: gpgme_status_code_t = 74;
pub const gpgme_status_code_t_GPGME_STATUS_SC_OP_FAILURE: gpgme_status_code_t = 75;
pub const gpgme_status_code_t_GPGME_STATUS_SC_OP_SUCCESS: gpgme_status_code_t = 76;
pub const gpgme_status_code_t_GPGME_STATUS_CARDCTRL: gpgme_status_code_t = 77;
pub const gpgme_status_code_t_GPGME_STATUS_BACKUP_KEY_CREATED: gpgme_status_code_t = 78;
pub const gpgme_status_code_t_GPGME_STATUS_PKA_TRUST_BAD: gpgme_status_code_t = 79;
pub const gpgme_status_code_t_GPGME_STATUS_PKA_TRUST_GOOD: gpgme_status_code_t = 80;
pub const gpgme_status_code_t_GPGME_STATUS_PLAINTEXT: gpgme_status_code_t = 81;
pub const gpgme_status_code_t_GPGME_STATUS_INV_SGNR: gpgme_status_code_t = 82;
pub const gpgme_status_code_t_GPGME_STATUS_NO_SGNR: gpgme_status_code_t = 83;
pub const gpgme_status_code_t_GPGME_STATUS_SUCCESS: gpgme_status_code_t = 84;
pub const gpgme_status_code_t_GPGME_STATUS_DECRYPTION_INFO: gpgme_status_code_t = 85;
pub const gpgme_status_code_t_GPGME_STATUS_PLAINTEXT_LENGTH: gpgme_status_code_t = 86;
pub const gpgme_status_code_t_GPGME_STATUS_MOUNTPOINT: gpgme_status_code_t = 87;
pub const gpgme_status_code_t_GPGME_STATUS_PINENTRY_LAUNCHED: gpgme_status_code_t = 88;
pub const gpgme_status_code_t_GPGME_STATUS_ATTRIBUTE: gpgme_status_code_t = 89;
pub const gpgme_status_code_t_GPGME_STATUS_BEGIN_SIGNING: gpgme_status_code_t = 90;
pub const gpgme_status_code_t_GPGME_STATUS_KEY_NOT_CREATED: gpgme_status_code_t = 91;
pub const gpgme_status_code_t_GPGME_STATUS_INQUIRE_MAXLEN: gpgme_status_code_t = 92;
pub const gpgme_status_code_t_GPGME_STATUS_FAILURE: gpgme_status_code_t = 93;
pub const gpgme_status_code_t_GPGME_STATUS_KEY_CONSIDERED: gpgme_status_code_t = 94;
pub const gpgme_status_code_t_GPGME_STATUS_TOFU_USER: gpgme_status_code_t = 95;
pub const gpgme_status_code_t_GPGME_STATUS_TOFU_STATS: gpgme_status_code_t = 96;
pub const gpgme_status_code_t_GPGME_STATUS_TOFU_STATS_LONG: gpgme_status_code_t = 97;
pub const gpgme_status_code_t_GPGME_STATUS_NOTATION_FLAGS: gpgme_status_code_t = 98;
pub const gpgme_status_code_t_GPGME_STATUS_DECRYPTION_COMPLIANCE_MODE: gpgme_status_code_t = 99;
pub const gpgme_status_code_t_GPGME_STATUS_VERIFICATION_COMPLIANCE_MODE: gpgme_status_code_t = 100;
pub type gpgme_status_code_t = u32;
pub type gpgme_edit_cb_t = ::std::option::Option<
    unsafe extern "C" fn(
        opaque: *mut ::std::os::raw::c_void,
        status: gpgme_status_code_t,
        args: *const ::std::os::raw::c_char,
        fd: ::std::os::raw::c_int,
    ) -> gpgme_error_t,
>;
extern "C" {
    pub fn gpgme_op_edit_start(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        fnc: gpgme_edit_cb_t,
        fnc_value: *mut ::std::os::raw::c_void,
        out: gpgme_data_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_edit(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        fnc: gpgme_edit_cb_t,
        fnc_value: *mut ::std::os::raw::c_void,
        out: gpgme_data_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_card_edit_start(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        fnc: gpgme_edit_cb_t,
        fnc_value: *mut ::std::os::raw::c_void,
        out: gpgme_data_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_op_card_edit(
        ctx: gpgme_ctx_t,
        key: gpgme_key_t,
        fnc: gpgme_edit_cb_t,
        fnc_value: *mut ::std::os::raw::c_void,
        out: gpgme_data_t,
    ) -> gpgme_error_t;
}
pub const _gpgme_sig_stat_t_GPGME_SIG_STAT_NONE: _gpgme_sig_stat_t = 0;
pub const _gpgme_sig_stat_t_GPGME_SIG_STAT_GOOD: _gpgme_sig_stat_t = 1;
pub const _gpgme_sig_stat_t_GPGME_SIG_STAT_BAD: _gpgme_sig_stat_t = 2;
pub const _gpgme_sig_stat_t_GPGME_SIG_STAT_NOKEY: _gpgme_sig_stat_t = 3;
pub const _gpgme_sig_stat_t_GPGME_SIG_STAT_NOSIG: _gpgme_sig_stat_t = 4;
pub const _gpgme_sig_stat_t_GPGME_SIG_STAT_ERROR: _gpgme_sig_stat_t = 5;
pub const _gpgme_sig_stat_t_GPGME_SIG_STAT_DIFF: _gpgme_sig_stat_t = 6;
pub const _gpgme_sig_stat_t_GPGME_SIG_STAT_GOOD_EXP: _gpgme_sig_stat_t = 7;
pub const _gpgme_sig_stat_t_GPGME_SIG_STAT_GOOD_EXPKEY: _gpgme_sig_stat_t = 8;
pub type _gpgme_sig_stat_t = u32;
pub use self::_gpgme_sig_stat_t as gpgme_sig_stat_t;
pub const _gpgme_attr_t_GPGME_ATTR_KEYID: _gpgme_attr_t = 1;
pub const _gpgme_attr_t_GPGME_ATTR_FPR: _gpgme_attr_t = 2;
pub const _gpgme_attr_t_GPGME_ATTR_ALGO: _gpgme_attr_t = 3;
pub const _gpgme_attr_t_GPGME_ATTR_LEN: _gpgme_attr_t = 4;
pub const _gpgme_attr_t_GPGME_ATTR_CREATED: _gpgme_attr_t = 5;
pub const _gpgme_attr_t_GPGME_ATTR_EXPIRE: _gpgme_attr_t = 6;
pub const _gpgme_attr_t_GPGME_ATTR_OTRUST: _gpgme_attr_t = 7;
pub const _gpgme_attr_t_GPGME_ATTR_USERID: _gpgme_attr_t = 8;
pub const _gpgme_attr_t_GPGME_ATTR_NAME: _gpgme_attr_t = 9;
pub const _gpgme_attr_t_GPGME_ATTR_EMAIL: _gpgme_attr_t = 10;
pub const _gpgme_attr_t_GPGME_ATTR_COMMENT: _gpgme_attr_t = 11;
pub const _gpgme_attr_t_GPGME_ATTR_VALIDITY: _gpgme_attr_t = 12;
pub const _gpgme_attr_t_GPGME_ATTR_LEVEL: _gpgme_attr_t = 13;
pub const _gpgme_attr_t_GPGME_ATTR_TYPE: _gpgme_attr_t = 14;
pub const _gpgme_attr_t_GPGME_ATTR_IS_SECRET: _gpgme_attr_t = 15;
pub const _gpgme_attr_t_GPGME_ATTR_KEY_REVOKED: _gpgme_attr_t = 16;
pub const _gpgme_attr_t_GPGME_ATTR_KEY_INVALID: _gpgme_attr_t = 17;
pub const _gpgme_attr_t_GPGME_ATTR_UID_REVOKED: _gpgme_attr_t = 18;
pub const _gpgme_attr_t_GPGME_ATTR_UID_INVALID: _gpgme_attr_t = 19;
pub const _gpgme_attr_t_GPGME_ATTR_KEY_CAPS: _gpgme_attr_t = 20;
pub const _gpgme_attr_t_GPGME_ATTR_CAN_ENCRYPT: _gpgme_attr_t = 21;
pub const _gpgme_attr_t_GPGME_ATTR_CAN_SIGN: _gpgme_attr_t = 22;
pub const _gpgme_attr_t_GPGME_ATTR_CAN_CERTIFY: _gpgme_attr_t = 23;
pub const _gpgme_attr_t_GPGME_ATTR_KEY_EXPIRED: _gpgme_attr_t = 24;
pub const _gpgme_attr_t_GPGME_ATTR_KEY_DISABLED: _gpgme_attr_t = 25;
pub const _gpgme_attr_t_GPGME_ATTR_SERIAL: _gpgme_attr_t = 26;
pub const _gpgme_attr_t_GPGME_ATTR_ISSUER: _gpgme_attr_t = 27;
pub const _gpgme_attr_t_GPGME_ATTR_CHAINID: _gpgme_attr_t = 28;
pub const _gpgme_attr_t_GPGME_ATTR_SIG_STATUS: _gpgme_attr_t = 29;
pub const _gpgme_attr_t_GPGME_ATTR_ERRTOK: _gpgme_attr_t = 30;
pub const _gpgme_attr_t_GPGME_ATTR_SIG_SUMMARY: _gpgme_attr_t = 31;
pub const _gpgme_attr_t_GPGME_ATTR_SIG_CLASS: _gpgme_attr_t = 32;
pub type _gpgme_attr_t = u32;
pub use self::_gpgme_attr_t as gpgme_attr_t;
extern "C" {
    pub fn gpgme_get_sig_status(
        ctx: gpgme_ctx_t,
        idx: ::std::os::raw::c_int,
        r_stat: *mut _gpgme_sig_stat_t,
        r_created: *mut time_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn gpgme_get_sig_ulong_attr(
        c: gpgme_ctx_t,
        idx: ::std::os::raw::c_int,
        what: _gpgme_attr_t,
        whatidx: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn gpgme_get_sig_string_attr(
        c: gpgme_ctx_t,
        idx: ::std::os::raw::c_int,
        what: _gpgme_attr_t,
        whatidx: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn gpgme_get_sig_key(
        ctx: gpgme_ctx_t,
        idx: ::std::os::raw::c_int,
        r_key: *mut gpgme_key_t,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_data_new_with_read_cb(
        r_dh: *mut gpgme_data_t,
        read_cb: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_char,
                arg3: usize,
                arg4: *mut usize,
            ) -> ::std::os::raw::c_int,
        >,
        read_cb_value: *mut ::std::os::raw::c_void,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_key_get_string_attr(
        key: gpgme_key_t,
        what: _gpgme_attr_t,
        reserved: *const ::std::os::raw::c_void,
        idx: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn gpgme_key_get_ulong_attr(
        key: gpgme_key_t,
        what: _gpgme_attr_t,
        reserved: *const ::std::os::raw::c_void,
        idx: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn gpgme_key_sig_get_string_attr(
        key: gpgme_key_t,
        uid_idx: ::std::os::raw::c_int,
        what: _gpgme_attr_t,
        reserved: *const ::std::os::raw::c_void,
        idx: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn gpgme_key_sig_get_ulong_attr(
        key: gpgme_key_t,
        uid_idx: ::std::os::raw::c_int,
        what: _gpgme_attr_t,
        reserved: *const ::std::os::raw::c_void,
        idx: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn gpgme_op_import_ext(
        ctx: gpgme_ctx_t,
        keydata: gpgme_data_t,
        nr: *mut ::std::os::raw::c_int,
    ) -> gpgme_error_t;
}
extern "C" {
    pub fn gpgme_trust_item_release(item: gpgme_trust_item_t);
}
extern "C" {
    pub fn gpgme_trust_item_get_string_attr(
        item: gpgme_trust_item_t,
        what: _gpgme_attr_t,
        reserved: *const ::std::os::raw::c_void,
        idx: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn gpgme_trust_item_get_int_attr(
        item: gpgme_trust_item_t,
        what: _gpgme_attr_t,
        reserved: *const ::std::os::raw::c_void,
        idx: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _gpgme_op_assuan_result {
    pub err: gpgme_error_t,
}
#[test]
fn bindgen_test_layout__gpgme_op_assuan_result() {
    assert_eq!(
        ::std::mem::size_of::<_gpgme_op_assuan_result>(),
        4usize,
        concat!("Size of: ", stringify!(_gpgme_op_assuan_result))
    );
    assert_eq!(
        ::std::mem::align_of::<_gpgme_op_assuan_result>(),
        4usize,
        concat!("Alignment of ", stringify!(_gpgme_op_assuan_result))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_gpgme_op_assuan_result>())).err as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_gpgme_op_assuan_result),
            "::",
            stringify!(err)
        )
    );
}
pub type gpgme_assuan_result_t = *mut _gpgme_op_assuan_result;
extern "C" {
    pub fn gpgme_op_assuan_result(ctx: gpgme_ctx_t) -> gpgme_assuan_result_t;
}
extern "C" {
    pub fn gpgme_op_assuan_transact(
        ctx: gpgme_ctx_t,
        command: *const ::std::os::raw::c_char,
        data_cb: gpgme_assuan_data_cb_t,
        data_cb_value: *mut ::std::os::raw::c_void,
        inq_cb: gpgme_assuan_inquire_cb_t,
        inq_cb_value: *mut ::std::os::raw::c_void,
        status_cb: gpgme_assuan_status_cb_t,
        status_cb_value: *mut ::std::os::raw::c_void,
    ) -> gpgme_error_t;
}
pub type GpgmeCtx = gpgme_ctx_t;
pub type GpgmeData = gpgme_data_t;
pub type GpgmeError = gpgme_error_t;
pub use self::gpgme_attr_t as GpgmeAttr;
pub use self::gpgme_data_encoding_t as GpgmeDataEncoding;
pub use self::gpgme_hash_algo_t as GpgmeHashAlgo;
pub use self::gpgme_protocol_t as GpgmeProtocol;
pub use self::gpgme_pubkey_algo_t as GpgmePubKeyAlgo;
pub use self::gpgme_sig_mode_t as GpgmeSigMode;
pub use self::gpgme_sig_stat_t as GpgmeSigStat;
pub use self::gpgme_validity_t as GpgmeValidity;
pub type GpgmeEngineInfo = gpgme_engine_info_t;
pub type GpgmeSubkey = gpgme_subkey_t;
pub type GpgmeKeySig = gpgme_key_sig_t;
pub type GpgmeUserID = gpgme_user_id_t;
pub type GpgmeKey = gpgme_key_t;
pub type GpgmePassphraseCb = gpgme_passphrase_cb_t;
pub type GpgmeProgressCb = gpgme_progress_cb_t;
pub type GpgmeIOCb = gpgme_io_cb_t;
pub type GpgmeRegisterIOCb = gpgme_register_io_cb_t;
pub type GpgmeRemoveIOCb = gpgme_remove_io_cb_t;
pub use self::gpgme_event_io_t as GpgmeEventIO;
pub type GpgmeEventIOCb = gpgme_event_io_cb_t;
pub type GpgmeDataReadCb = gpgme_data_read_cb_t;
pub type GpgmeDataWriteCb = gpgme_data_write_cb_t;
pub type GpgmeDataSeekCb = gpgme_data_seek_cb_t;
pub type GpgmeDataReleaseCb = gpgme_data_release_cb_t;
pub type GpgmeEncryptResult = gpgme_encrypt_result_t;
pub type GpgmeSigNotation = gpgme_sig_notation_t;
pub type GpgmeSignature = gpgme_signature_t;
pub type GpgmeVerifyResult = gpgme_verify_result_t;
pub type GpgmeImportStatus = gpgme_import_status_t;
pub type GpgmeImportResult = gpgme_import_result_t;
pub type GpgmeGenKeyResult = gpgme_genkey_result_t;
pub type GpgmeTrustItem = gpgme_trust_item_t;
pub use self::gpgme_status_code_t as GpgmeStatusCode;
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout___va_list_tag() {
    assert_eq!(
        ::std::mem::size_of::<__va_list_tag>(),
        24usize,
        concat!("Size of: ", stringify!(__va_list_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<__va_list_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(__va_list_tag))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).gp_offset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(gp_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).fp_offset as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(fp_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).overflow_arg_area as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(overflow_arg_area)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).reg_save_area as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(reg_save_area)
        )
    );
}
