use std::env;

// The Config struct is used to gather all of the configuration into one place.
// At the moment, it is a combination of hard coding and environment variables.
// I have not really planned ahead to thing where it is going to get the config from long term
// but, lets learn to walk before we run ?
#[derive(Debug)]
pub struct Config {
    pub api_url: String,
    pub api_password: String,
    pub api_username: String
}

impl Config {
    pub fn new_with_creds(username: String, password: String) -> Config {
        Config {
            api_url: String::from("https://app.melcloud.com/Mitsubishi.Wifi.Client"),
            api_username: username,
            api_password: password
        }
    }
    pub fn new(url: &str, username: &str, password: &str) -> Config {
        Config {
            api_url: String::from(url),
            api_username: String::from(username),
            api_password: String::from(password)
        }

    }
}
