// Below are the data structures returned by the API

use super::serde::{Deserialize};

#[derive(Serialize, Deserialize, Debug)]
#[serde(untagged)]
pub enum MelcloudLoginResponse {
    AccessDenied {
        #[serde(rename="ErrorId")]
        error_id: u32

    },
    Success {
        #[serde(rename="LoginData")]
        login_data: MelcloudLoginData
    }
}

#[derive(Serialize, Deserialize, Debug)]
pub struct MelcloudLoginData {
    #[serde(rename="ContextKey")]
    pub context_key: String
}

#[derive(Serialize, Deserialize, Debug)]
pub struct Building {
    #[serde(rename="ID")]
    pub id: u32,
    #[serde(rename="Name")]
    pub name: String,
    #[serde(rename="Structure")]
    pub structure: Structure
}

#[derive(Serialize, Deserialize, Debug)]
pub struct Structure {
    #[serde(rename="Floors")]
    pub floors: Vec<Floor>,

}
#[derive(Serialize, Deserialize, Debug)]
pub struct Floor {
    #[serde(rename="ID")]
    pub id: u32,
    #[serde(rename="Name")]
    pub name: String,
    #[serde(rename="Areas")]
    pub areas: Vec<Area>

}
#[derive(Serialize, Deserialize, Debug)]
pub struct Area {
    #[serde(rename="ID")]
    pub id: u32,
    #[serde(rename="Name")]
    pub name: String,
    #[serde(rename="Devices")]
    pub devices: Vec<DeviceHeader>

}
#[derive(Serialize, Deserialize, Debug)]
pub struct DeviceHeader {
    #[serde(rename="DeviceID")]
    pub id: u32,
    #[serde(rename="DeviceName")]
    pub name: String,
    #[serde(rename="Device")]
    pub device: Device

}
#[derive(Serialize, Deserialize, Debug)]
pub struct Device {
    #[serde(rename="DeviceType")]
    pub device_type: u32,
    #[serde(rename="HeatPumpFrequency")]
    pub heat_pump_frequency: u32,
    #[serde(rename="FlowTemperature")]
    pub flow_temperature: f32,
    #[serde(rename="ReturnTemperature")]
    pub return_temperature: f32,
    #[serde(rename="FlowTemperatureZone1")]
    pub flow_temperature_zone_1: f32,
    #[serde(rename="ReturnTemperatureZone1")]
    pub return_temperature_zone_1: f32,
    #[serde(rename="FlowTemperatureZone2")]
    pub flow_temperature_zone_2: f32,
    #[serde(rename="ReturnTemperatureZone2")]
    pub return_temperature_zone_2: f32,
    #[serde(rename="FlowTemperatureBoiler")]
    pub flow_temperature_boiler: f32,
    #[serde(rename="ReturnTemperatureBoiler")]
    pub return_temperature_boiler: f32,
    #[serde(rename="MaxSetTemperature")]
    pub max_set_temperature: f32,
    #[serde(rename="MinSetTemperature")]
    pub min_set_temperature: f32,
    #[serde(rename="RoomTemperatureZone1")]
    pub room_temperature_zone_1: f32,
    #[serde(rename="RoomTemperatureZone2")]
    pub room_temperature_zone_2: f32,
    #[serde(rename="OutdoorTemperature")]
    pub outdoor_temperature: f32,
    #[serde(rename="CurrentEnergyConsumed")]
    pub current_energy_consumed: u32,
    #[serde(rename="CurrentEnergyProduced")]
    pub current_energy_produced: u32,
    #[serde(rename="CurrentEnergyMode")]
    pub current_energy_mode: u32,
    #[serde(rename="HeatingEnergyConsumedRate1")]
    pub heating_energy_consumed_rate_1: u32,
    #[serde(rename="HeatingEnergyConsumedRate2")]
    pub heating_energy_consumed_rate_2: u32,
    #[serde(rename="BoilerStatus")]
    pub boiler_status: bool,
    #[serde(rename="BoosterHeater1Status")]
    pub booster_heater_1_status: bool,
    #[serde(rename="BoosterHeater2Status")]
    pub booster_heater_2_status: bool,
    #[serde(rename="BoosterHeater2PlusStatus")]
    pub booster_heater_2_plus_status: bool,
    #[serde(rename="ImmersionHeaterStatus")]
    pub immersion_heater_status: bool,
    #[serde(rename="WaterPump1Status")]
    pub water_pump_1_status: bool,
    #[serde(rename="WaterPump2Status")]
    pub water_pump_2_status: bool,
    #[serde(rename="WaterPump3Status")]
    pub water_pump_3_status: bool,
    #[serde(rename="ValveStatus3Way")]
    pub valve_status_3_way: bool,
    #[serde(rename="ValveStatus2Way")]
    pub valve_status_2_way: bool,
    #[serde(rename="WaterPump4Status")]
    pub water_pump_4_status: bool,
    #[serde(rename="ValveStatus2Way2a")]
    pub valve_status_2_way_2_a: bool,
    #[serde(rename="ValveStatus2Way2b")]
    pub valve_status_2_way_2_b: bool,
    #[serde(rename="TankWaterTemperature")]
    pub tank_water_temperature: f32,
    #[serde(rename="UnitStatus")]
    pub unit_status: u32,
    #[serde(rename="HeatingFunctionEnabled")]
    pub heating_function_enabled: bool,
    #[serde(rename="ServerTimerEnabled")]
    pub server_timer_enabled: bool,
    #[serde(rename="ThermostatStatusZone1")]
    pub thermostat_status_zone_1: bool,
    #[serde(rename="ThermostatStatusZone2")]
    pub thermostat_status_zone_2: bool,
    #[serde(rename="ThermostatTypeZone1")]
    pub thermostat_type_zone_1: u32,
    #[serde(rename="ThermostatTypeZone2")]
    pub thermostat_type_zone_2: u32,
    #[serde(rename="EffectiveFlags")]
    pub effective_flags: u64,
    #[serde(rename="LastEffectiveFlags")]
    pub last_effective_flags: u64,
    #[serde(rename="Power")]
    pub power: bool,
    #[serde(rename="EcoHotWater")]
    pub eco_hot_water: bool,
    #[serde(rename="OperationMode")]
    pub operation_mode: u32,
    #[serde(rename="OperationModeZone1")]
    pub operation_mode_zone_1: u32,
    #[serde(rename="OperationModeZone2")]
    pub operation_mode_zone_2: u32,
    #[serde(rename="SetTemperatureZone1")]
    pub set_temperature_zone_1: f32,
    #[serde(rename="SetTemperatureZone2")]
    pub set_temperature_zone_2: f32,
    #[serde(rename="SetTankWaterTemperature")]
    pub set_tank_water_temperature: f32,
    #[serde(rename="TargetHCTemperatureZone1")]
    pub target_hc_temperature_zone_1: f32,
    #[serde(rename="TargetHCTemperatureZone2")]
    pub target_hc_temperature_zone_2: f32,
    #[serde(rename="ForcedHotWaterMode")]
    pub forced_hot_water_mode: bool,
    #[serde(rename="HolidayMode")]
    pub holiday_mode: bool,
    #[serde(rename="ProhibitHotWater")]
    pub prohibit_hot_water: bool,
    #[serde(rename="ProhibitHeatingZone1")]
    pub prohibit_heating_zone_1: bool,
    #[serde(rename="ProhibitHeatingZone2")]
    pub prohibit_heating_zone_2: bool,
    #[serde(rename="ProhibitCoolingZone1")]
    pub prohibit_cooling_zone_1: bool,
    #[serde(rename="ProhibitCoolingZone2")]
    pub prohibit_cooling_zone_2: bool,
    #[serde(rename="ServerTimerDesired")]
    pub server_timer_desired: bool,
    #[serde(rename="SecondaryZoneHeatCurve")]
    pub secondary_zone_heat_curve: bool,
    #[serde(rename="SetHeatFlowTemperatureZone1")]
    pub set_heat_flow_temperature_zone_1: f32,
    #[serde(rename="SetHeatFlowTemperatureZone2")]
    pub set_heat_flow_temperature_zone_2: f32,
    #[serde(rename="SetCoolFlowTemperatureZone1")]
    pub set_cool_flow_temperature_zone_1: f32,
    #[serde(rename="SetCoolFlowTemperatureZone2")]
    pub set_cool_flow_temperature_zone_2: f32,
    #[serde(rename="ThermostatTemperatureZone1")]
    pub thermostat_temperature_zone_1: f32,
    #[serde(rename="ThermostatTemperatureZone2")]
    pub thermostat_temperature_zone_2: f32,
    #[serde(rename="DECCReport")]
    pub decc_report: bool,
    #[serde(rename="CSVReport1min")]
    pub csv_report_1_min: bool,
    #[serde(rename="Zone2Master")]
    pub zone_2_master: bool,
    #[serde(rename="DailyEnergyConsumedDate")]
    pub daily_energy_consumed_date: String,
    #[serde(rename="DailyEnergyProducedDate")]
    pub daily_energy_produced_date: String,
    #[serde(rename="CoolingEnergyConsumedRate1")]
    pub cooling_energy_consumed_rate_1: u32,
    #[serde(rename="CoolingEnergyConsumedRate2")]
    pub cooling_energy_consumed_rate_2: u32,
    #[serde(rename="HotWaterEnergyConsumedRate1")]
    pub hot_water_energy_consumed_rate_1: u32,
    #[serde(rename="HotWaterEnergyConsumedRate2")]
    pub hot_water_energy_consumed_rate_2: u32,
    #[serde(rename="HeatingEnergyProducedRate1")]
    pub heating_energy_produced_rate_1: u32,
    #[serde(rename="HeatingEnergyProducedRate2")]
    pub heating_energy_produced_rate_2: u32,
    #[serde(rename="CoolingEnergyProducedRate1")]
    pub cooling_energy_produced_rate_1: u32,
    #[serde(rename="CoolingEnergyProducedRate2")]
    pub cooling_energy_produced_rate_2: u32,
    #[serde(rename="HotWaterEnergyProducedRate1")]
    pub hot_water_energy_produced_rate_1: u32,
    #[serde(rename="HotWaterEnergyProducedRate2")]
    pub hot_water_energy_produced_rate_2: u32,
    #[serde(rename="ErrorCode2Digit")]
    pub error_code_2_digit: u32,
    #[serde(rename="SendSpecialFunctions")]
    pub send_special_functions: u32,
    #[serde(rename="RequestSpecialFunctions")]
    pub request_special_functions: u32,
    #[serde(rename="SpecialFunctionsState")]
    pub special_functions_state: u32,
    #[serde(rename="PendingSendSpecialFunctions")]
    pub pending_send_special_functions: u32,
    #[serde(rename="PendingRequestSpecialFunctions")]
    pub pending_request_special_functions: u32,
    #[serde(rename="HasZone2")]
    pub has_zone_2: bool,
    #[serde(rename="HasSimplifiedZone2")]
    pub has_simplified_zone_2: bool,
    #[serde(rename="CanHeat")]
    pub can_heat: bool,
    #[serde(rename="CanCool")]
    pub can_cool: bool,
    #[serde(rename="HasHotWaterTank")]
    pub has_hot_water_tank: bool,
    #[serde(rename="CanSetTankTemperature")]
    pub can_set_tank_temperature: bool,
    #[serde(rename="CanSetEcoHotWater")]
    pub can_set_eco_hot_water: bool,
    #[serde(rename="HasEnergyConsumedMeter")]
    pub has_energy_consumed_meter: bool,
    #[serde(rename="HasEnergyProducedMeter")]
    pub has_energy_produced_meter: bool,
    #[serde(rename="CanMeasureEnergyProduced")]
    pub can_measure_energy_produced: bool,
    #[serde(rename="CanMeasureEnergyConsumed")]
    pub can_measure_energy_consumed: bool,
    #[serde(rename="Zone1InRoomMode")]
    pub zone_1_in_room_mode: bool,
    #[serde(rename="Zone2InRoomMode")]
    pub zone_2_in_room_mode: bool,
    #[serde(rename="Zone1InHeatMode")]
    pub zone_1_in_heat_mode: bool,
    #[serde(rename="Zone2InHeatMode")]
    pub zone_2_in_heat_mode: bool,
    #[serde(rename="Zone1InCoolMode")]
    pub zone_1_in_cool_mode: bool,
    #[serde(rename="Zone2InCoolMode")]
    pub zone_2_in_cool_mode: bool,
    #[serde(rename="AllowDualRoomTemperature")]
    pub allow_dual_room_temperature: bool,
    #[serde(rename="HasEcoCuteSettings")]
    pub has_eco_cute_settings: bool,
    #[serde(rename="HasFTC45Settings")]
    pub has_ftc_45_settings: bool,
    #[serde(rename="CanEstimateEnergyUsage")]
    pub can_estimate_energy_usage: bool,
    #[serde(rename="CanUseRoomTemperatureCooling")]
    pub can_use_room_temperature_cooling: bool,
    #[serde(rename="IsFtcModelSupported")]
    pub is_ftc_model_supported: bool,
    #[serde(rename="MaxTankTemperature")]
    pub max_tank_temperature: f32,
    #[serde(rename="IdleZone1")]
    pub idle_zone_1: bool,
    #[serde(rename="IdleZone2")]
    pub idle_zone_2: bool,
    #[serde(rename="MinPcycle")]
    pub min_pcycle: u32,
    #[serde(rename="MaxPcycle")]
    pub max_pcycle: u32,
    #[serde(rename="MaxOutdoorUnits")]
    pub max_outdoor_units: u32,
    #[serde(rename="MaxIndoorUnits")]
    pub max_indoor_units: u32,
    #[serde(rename="MaxTemperatureControlUnits")]
    pub max_temperature_control_units: u32,
    #[serde(rename="DeviceID")]
    pub device_id: u32,
    #[serde(rename="MacAddress")]
    pub mac_address: String,
    #[serde(rename="SerialNumber")]
    pub serial_number: String,
    #[serde(rename="TimeZoneID")]
    pub time_zone_id: u32,
    #[serde(rename="DiagnosticMode")]
    pub diagnostic_mode: u32,
    #[serde(rename="DiagnosticEndDate")]
    pub diagnostic_end_date: Option<String>,
    #[serde(rename="ExpectedCommand")]
    pub expected_command: u32,
    #[serde(rename="Owner")]
    pub owner: Option<String>,
    #[serde(rename="DetectedCountry")]
    pub detected_country: Option<String>,
    #[serde(rename="AdaptorType")]
    pub adaptor_type: i32,
    #[serde(rename="FirmwareDeployment")]
    pub firmware_deployment: Option<String>,
    #[serde(rename="FirmwareUpdateAborted")]
    pub firmware_update_aborted: bool,
    #[serde(rename="LinkedDevice")]
    pub linked_device: Option<String>,
    #[serde(rename="WifiSignalStrength")]
    pub wifi_signal_strength: i32,
    #[serde(rename="WifiAdapterStatus")]
    pub wifi_adapter_status: String,
    #[serde(rename="Position")]
    pub position: String,
    #[serde(rename="PCycle")]
    pub p_cycle: u32,
    #[serde(rename="RecordNumMax")]
    pub record_num_max: u32,
    #[serde(rename="LastTimeStamp")]
    pub last_time_stamp: String,
    #[serde(rename="ErrorCode")]
    pub error_code: u32,
    #[serde(rename="HasError")]
    pub has_error: bool,
    #[serde(rename="LastReset")]
    pub last_reset: String,
    #[serde(rename="FlashWrites")]
    pub flash_writes: u32,
    #[serde(rename="Scene")]
    pub scene: Option<String>,
    #[serde(rename="TemperatureIncrementOverride")]
    pub temperature_increment_override: u32,
    #[serde(rename="SSLExpirationDate")]
    pub ssl_expiration_date: String,
    #[serde(rename="SPTimeout")]
    pub sp_timeout: u32,
    #[serde(rename="Passcode")]
    pub passcode: Option<String>,
    #[serde(rename="ServerCommunicationDisabled")]
    pub server_communication_disabled: bool,
    #[serde(rename="ConsecutiveUploadErrors")]
    pub consecutive_upload_errors: u32,
    #[serde(rename="DoNotRespondAfter")]
    pub do_not_respond_after: Option<String>,
    #[serde(rename="OwnerRoleAccessLevel")]
    pub owner_role_access_level: u32,
    #[serde(rename="OwnerCountry")]
    pub owner_country: u32,
    #[serde(rename="HideEnergyReport")]
    pub hide_energy_report: bool,
    #[serde(rename="Rate1StartTime")]
    pub rate_1_start_time: Option<String>,
    #[serde(rename="Rate2StartTime")]
    pub rate_2_start_time: Option<String>,
    #[serde(rename="ProtocolVersion")]
    pub protocol_version: u32,
    #[serde(rename="UnitVersion")]
    pub unit_version: u32,
    #[serde(rename="FirmwareAppVersion")]
    pub firmware_app_version: u32,
    #[serde(rename="FirmwareWebVersion")]
    pub firmware_web_version: u32,
    #[serde(rename="FirmwareWlanVersion")]
    pub firmware_wlan_version: u32,
    #[serde(rename="EffectivePCycle")]
    pub effective_p_cycle: u32,
    #[serde(rename="HasErrorMessages")]
    pub has_error_messages: bool,
    #[serde(rename="Offline")]
    pub offline: bool
}
#[derive(Serialize, Deserialize, Debug, Clone)]
pub struct DeviceLessDetail {
    #[serde(rename="EffectiveFlags")]
    pub effective_flags: u64,
    #[serde(rename="LocalIPAddress")]
    local_ip_address: Option<String>,
    #[serde(rename="SetTemperatureZone1")]
    set_temperature_zone_1: f32,
    #[serde(rename="SetTemperatureZone2")]
    set_temperature_zone_2: f32,
    #[serde(rename="RoomTemperatureZone1")]
    room_temperature_zone_1: f32,
    #[serde(rename="RoomTemperatureZone2")]
    room_temperature_zone_2: f32,
    #[serde(rename="OperationMode")]
    operation_mode: u32,
    #[serde(rename="OperationModeZone1")]
    operation_mode_zone_1: u32,
    #[serde(rename="OperationModeZone2")]
    operation_mode_zone_2: u32,
    #[serde(rename="WeatherObservations")]
    weather_observations: Vec<WeatherObservation>,
    #[serde(rename="ErrorMessage")]
    error_message: Option<String>,
    #[serde(rename="ErrorCode")]
    error_code: u32,
    #[serde(rename="SetHeatFlowTemperatureZone1")]
    pub set_heat_flow_temperature_zone_1: f32,
    #[serde(rename="SetHeatFlowTemperatureZone2")]
    set_heat_flow_temperature_zone_2: f32,
    #[serde(rename="SetCoolFlowTemperatureZone1")]
    set_cool_flow_temperature_zone_1: f32,
    #[serde(rename="SetCoolFlowTemperatureZone2")]
    set_cool_flow_temperature_zone_2: f32,
    #[serde(rename="HCControlType")]
    hc_control_type: u32,
    #[serde(rename="TankWaterTemperature")]
    tank_water_temperature: f32,
    #[serde(rename="SetTankWaterTemperature")]
    set_tank_water_temperature: f32,
    #[serde(rename="ForcedHotWaterMode")]
    forced_hot_water_mode: bool,
    #[serde(rename="UnitStatus")]
    unit_status: u32,
    #[serde(rename="OutdoorTemperature")]
    outdoor_temperature: f32,
    #[serde(rename="EcoHotWater")]
    eco_hot_water: bool,
    #[serde(rename="Zone1Name")]
    zone_1_name: Option<String>,
    #[serde(rename="Zone2Name")]
    zone_2_name: Option<String>,
    #[serde(rename="HolidayMode")]
    holiday_mode: bool,
    #[serde(rename="ProhibitZone1")]
    prohibit_zone_1: bool,
    #[serde(rename="ProhibitZone2")]
    prohibit_zone_2: bool,
    #[serde(rename="ProhibitHotWater")]
    prohibit_hot_water: bool,
    #[serde(rename="TemperatureIncrementOverride")]
    temperature_increment_override: u32,
    #[serde(rename="IdleZone1")]
    idle_zone_1: bool,
    #[serde(rename="IdleZone2")]
    idle_zone_2: bool,
    #[serde(rename="DeviceID")]
    device_id: u32,
    #[serde(rename="DeviceType")]
    device_type: u32,
    #[serde(rename="LastCommunication")]
    last_communication: String,
    #[serde(rename="NextCommunication")]
    next_communication: String,
    #[serde(rename="Power")]
    power: bool,
    #[serde(rename="HasPendingCommand")]
    pub has_pending_command: bool,
    #[serde(rename="Offline")]
    offline: bool,
    #[serde(rename="Scene")]
    scene: Option<String>,
    #[serde(rename="SceneOwner")]
    scene_owner: Option<String>
}

#[derive(Serialize, Deserialize, Debug, Clone)]
pub struct WeatherObservation {
    #[serde(rename="Date")]
    date: String,
    #[serde(rename="Sunrise")]
    sunrise: String,
    #[serde(rename="Sunset")]
    sunset: String,
    #[serde(rename="Condition")]
    condition: u32,
    #[serde(rename="ID")]
    id: u32,
    #[serde(rename="Humidity")]
    humidity: u32,
    #[serde(rename="Temperature")]
    temperature: u32,
    #[serde(rename="Icon")]
    icon: String,
    #[serde(rename="ConditionName")]
    condition_name: String,
    #[serde(rename="Day")]
    day: u32,
    #[serde(rename="WeatherType")]
    weather_type: u32
}