/**
 * \file dnn/src/cuda/local/cuda-convnet2/cudaconv2.cuh
 * MegEngine is Licensed under the Apache License, Version 2.0 (the "License")
 *
 * Copyright (c) 2014-2021 Megvii Inc. All rights reserved.
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT ARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 */
/**
 * Copyright 2014 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * --------------------------------------------------------------------------
 * * This file has been modified by Megvii ("Megvii Modifications").
 * * All Megvii Modifications are Copyright (C) 2014-2021 Megvii Inc. All rights
 * reserved.
 * --------------------------------------------------------------------------
 */

#ifndef COMMON_CUH
#define COMMON_CUH

#define MIN(x, y) ((x) < (y) ? (x) : (y))
#define MAX(x, y) ((x) > (y) ? (x) : (y))
#include "helper_cuda.h"  // helper functions CUDA error checking and initialization
#include "nvmatrix.cuh"

namespace megdnn {
namespace cuda {

enum FILTER_OUTPUT_ORDER { MODULE_FILTER_IMAGE, FILTER_MODULE_IMAGE };

void convFilterActs(
        cudaStream_t stream, NVMatrix& images, NVMatrix& filters, NVMatrix& targets,
        int imgSizeY, int numModulesY, int numModulesX, int paddingStart,
        int moduleStride, int numImgColors, int numGroups);
void convFilterActs(
        cudaStream_t stream, NVMatrix& images, NVMatrix& filters, NVMatrix& targets,
        int imgSizeY, int numModulesY, int numModulesX, int paddingStart,
        int moduleStride, int numImgColors, int numGroups, float scaleTargets,
        float scaleOutput);

void localFilterActs(
        cudaStream_t stream, NVMatrix& images, NVMatrix& filters, NVMatrix& targets,
        int imgSizeY, int numModulesY, int numModulesX, int paddingStart,
        int moduleStride, int numImgColors, int numGroups);
void localFilterActs(
        cudaStream_t stream, NVMatrix& images, NVMatrix& filters, NVMatrix& targets,
        int imgSizeY, int numModulesY, int numModulesX, int paddingStart,
        int moduleStride, int numImgColors, int numGroups, float scaleTargets,
        float scaleOutput);

void convImgActs(
        cudaStream_t stream, NVMatrix& hidActs, NVMatrix& filters, NVMatrix& targets,
        int imgSizeY, int imgSizeX, int numModulesY, int paddingStart, int moduleStride,
        int numImgColors, int numGroups);
void convImgActs(
        cudaStream_t stream, NVMatrix& hidActs, NVMatrix& filters, NVMatrix& targets,
        int imgSizeY, int imgSizeX, int numModulesY, int paddingStart, int moduleStride,
        int numImgColors, int numGroups, float scaleTargets, float scaleOutput);

void localImgActs(
        cudaStream_t stream, NVMatrix& hidActs, NVMatrix& filters, NVMatrix& targets,
        int imgSizeY, int imgSizeX, int numModulesY, int paddingStart, int moduleStride,
        int numImgColors, int numGroups);
void localImgActs(
        cudaStream_t stream, NVMatrix& hidActs, NVMatrix& filters, NVMatrix& targets,
        int imgSizeY, int imgSizeX, int numModulesY, int paddingStart, int moduleStride,
        int numImgColors, int numGroups, float scaleTargets, float scaleOutput);

void convWeightActs(
        cudaStream_t stream, NVMatrix& images, NVMatrix& hidActs, NVMatrix& targets,
        int imgSizeY, int numModulesY, int numModulesX, int filterSize,
        int paddingStart, int moduleStride, int numImgColors, int numGroups,
        int sumWidth);
void convWeightActs(
        cudaStream_t stream, NVMatrix& images, NVMatrix& hidActs, NVMatrix& targets,
        int imgSizeY, int numModulesY, int numModulesX, int filterSize,
        int paddingStart, int moduleStride, int numImgColors, int numGroups,
        int sumWidth, float scaleTargets, float scaleOutput);

void localWeightActs(
        cudaStream_t stream, NVMatrix& images, NVMatrix& hidActs, NVMatrix& targets,
        int imgSizeY, int numModulesY, int numModulesX, int filterSize,
        int paddingStart, int moduleStride, int numImgColors, int numGroups);

void localWeightActs(
        cudaStream_t stream, NVMatrix& images, NVMatrix& hidActs, NVMatrix& targets,
        int imgSizeY, int numModulesY, int numModulesX, int filterSize,
        int paddingStart, int moduleStride, int numImgColors, int numGroups,
        float scaleTargets, float scaleOutput);
}  // namespace cuda
}  // namespace megdnn

#endif /* COMMON_CUH */
