/**
 * \file dnn/src/arm_common/convolution/quint8/conv_backdata_stride1.h
 * MegEngine is Licensed under the Apache License, Version 2.0 (the "License")
 *
 * Copyright (c) 2014-2021 Megvii Inc. All rights reserved.
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT ARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 */
#pragma once

#include "src/arm_common/convolution/opr_impl.h"
#if MGB_ENABLE_DOT

namespace megdnn {
namespace arm_common {
namespace deconv {

using NCBKernSizeParam = ConvolutionBackwardDataImpl::NCBKernSizeParam;
using NCBKernParam = ConvolutionBackwardDataImpl::NCBKernParam;

bool can_stride1_quint8_dot(const NCBKernSizeParam& param);

void stride1_quint8_dot(const NCBKernParam& param);

size_t get_workspace_in_bytes_stride1_quint8_dot(const NCBKernSizeParam& param);

}  // namespace deconv
}  // namespace arm_common
}  // namespace megdnn
#endif

// vim: syntax=cpp.doxygen
