# Handbuch zur Bedienung der JwInf-Plattform "Medal"

Herzlichen Glückwunsch zur Wahl der JwInf-Plattform "Medal". Sie haben sich für
ein erstklassiges und stabiles Produkt entschieden. Bitte lesen Sie das folgende
Handbuch aufmerksam durch, damit Sie noch lange ein angenehmes Nutzererlebnis
mit der Plattform "Medal" haben.

#### Inhalt
 * [Bedienung für Teilnehmerinnen und Teilnehmer](#bedienung-f%C3%BCr-teilnehmerinnen-und-teilnehmer)
 * [Bedienung für Lehrkräfte und andere Betreuer](#bedienung-f%C3%BCr-lehrkr%C3%A4fte-und-andere-betreuer)
 * [Bedienung für Administratoren](#bedienung-f%C3%BCr-administratoren)
 * [Troubleshooting](#troubleshooting)


Bedienung für Teilnehmerinnen und Teilnehmer
-------------------------------------------

### Einloggen
Es gibt drei verschiedene Möglichkeiten sich zur Teilnahme am Jugendwettbewerb Informatik einzuloggen.

#### Einloggen mit Logincode
Gehe auf https://jwinf.de/. Gib den Logincode oben rechts im Feld `Gruppencode oder Logincode` ein. Drücke [Enter] oder klicke auf `Login`.

#### Einloggen mit Gruppencode
Gehe auf https://jwinf.de/. Gib den Gruppencode oben rechts im Feld `Gruppencode oder Logincode` ein. Drücke [Enter] oder klicke auf `Login`. Vervollständige nun dein Profil und klicke auf `Speichern`.

#### Einloggen mit BWINF-Account
Gehe auf https://jwinf.de/. Klicke oben rechts auf `BWINF-Login / Lehrer-Login`. Logge dich mit deinen BWINF-Accountdaten ein.

### Am Wettbewerb teilnehmen
Logge dich zunächst ein. Gehe dann auf die Fläche `Jugendwettbewerb Informatik – Aktuelle Wettbewerbe`. Wähle den Wettbewerb aus.

Du siehst nun einen gelben Button mit der Aufschrift `Jetzt starten!`. Sobald du dieses Button drückst, läuft die Wettbewerbszeit ab. Der Wettbewerb kann nach dem Starten nicht mehr pausiert werden!

Wenn du den Wettbewerb nicht starten kannst, kann das die folgenden Ursachen haben:

 * Du bist nicht eingeloggt: Du musst dich einloggen um Wettbewerbe starten zu können.
 * Der Wettbewerb hat noch nicht begonnen. Du kannst den Wettbewerb erst starten, wenn er begonnen hat. Die Zeit bis zum Begin wird angezeigt.
 * Der Wettbewerb ist schon beendet. Du kannst nicht mehr am Wettbewerb teilnehmen.
 * Deine Jahrgangsstufe entspricht nicht der Altersgruppe für die dieser Wettbewerb eingestellt ist. Wenn deine im Profil eingestellte Jahrgangsstufe korrekt ist, wähle einen anderen Wettbewerb aus, dessen Altersgruppe zu dir passt. Wenn deine im Profil eingestellte Jahrgangsstufe falsch ist, kannst du sie im Profil anpassen.

### Das Profil
Das Profil enthält deine persönlichen zum Account gehörenden Daten. Du kannst dort deinen Namen und deine Jahrgangsstufe angeben und deinen Logincode einsehen. Außerdem enthält dein Profil eine Liste aller Wettbewerbe und Trainingsbereiche, an denen du teilgenommen hast.

#### Profil aufrufen
Klicke oben rechts auf `Profil`. Du kannst dein Profil jederzeit anpassen.

#### Wettbewerbsergebnisse einsehen
Gehe auf dein Profil. Unten findest du eine Liste der Wettbewerbe. Wähle den passenden Wettbewerb aus. Du siehst nun dein Ergebnis.

### FAQ

##### Ich habe meinen Logincode nicht aufgeschrieben. Kann ich ihn noch einsehen?
Ja. Gehe dazu auf dein Profil. Dort wird der Logincode angezeigt.

##### Ich habe meinen Logincode nicht aufgeschrieben und mich bereits ausgeloggt. Kann ich mich nochmal mit dem Gruppencode einloggen.
Nein. Beim Einloggen mit dem Gruppencode wird ein neuer Account angelegt. Um deinen Logincode zu erfahren, frage deine Lehrkraft.

## Bedienung für Lehrkräfte und andere Betreuer

### Einloggen

#### Einloggen auf jwinf.de
Gehen Sie auf https://jwinf.de/. Klicken Sie oben rechts auf `BWINF-Login / Lehrer-Login`. Loggen Sie sich mit Ihren BWINF-Accountdaten ein. Wählen Sie im folgenden Menü Ihre Schule aus, mit der Sie sich für diese Sitzung anmelden möchten.

#### Einloggen über login.bwinf.de
Gehen Sie auf https://login.bwinf.de/ und loggen Sie sich ein. Wählen Sie oben in der Navigation `Wettbewerbe` und dann `Jugendwettbewerb Informatik` aus. Klicken Sie auf den ersten Link. Wählen Sie im folgenden Menü Ihre Schule aus, mit der Sie sich für diese Sitzung anmelden möchten.

### Gruppenverwaltung
In der Gruppenverwaltung können Sie neue Gruppen anlegen, bestehende Gruppen anpassen und die Wettbewerbsergebnisse einsehen. Sie können so viele Gruppen anlegen, wie Sie möchten.

#### Gruppenverwaltung aufrufen
Klicken Sie oben rechts auf `Gruppenverwaltung`.

#### Unterschied zwischen Gruppencode und Logincode
Sobald Sie eine Gruppe angelegt haben, erhalten Sie einen Gruppencode. Diesen müssen Sie an die Schülerinnen und Schüler weiter geben. Sobald diese sich mit dem Gruppencode registriert haben, sehen Sie die Angelmeldeten in ihrer Gruppenübersicht.
Wenn sich die Schülerinnen und Schüler mit dem Gruppencode registrieren, müssen sie ihre Daten eingeben und erhalten einen Logincode. Mit diesem Logincode melden sich die Schülerinnen und Schüler für die Teilnahme an den Wettbewerben (Probewettbewerb, 1. Runde, 2. Runde) an.

#### Neue Gruppe erstellen
Um eine neue Gruppe zu erstellen klicken Sie auf `Gruppenverwaltung`. Geben Sie im Feld `Gruppenname` den Namen der Gruppe an. Das Feld `Klassen-/Kursbezeichnung` ist optional. Es dient beim Ausdrucken der Urkunden zur richtigen Sortierung. Klicken Sie dann auf das Feld `Neue Gruppe anlegen`. Sie wechseln in die Gruppenansicht. Dort sehen Sie dann den Gruppencode, den Sie an Ihre Teilnehmerinnen und Teilnehmer weiter geben.

#### Neue Gruppe mit fertigen Accounts per CSV-Upload erstellen
Sie können die Gruppe auch mit Hilfe einer CSV-Datei erstellen. Gehen Sie dazu in die `Gruppenübersicht` und klicken Sie auf den Link `CSV Upload`. Es öffnet sich eine neue Seite, in der Sie die Datei hochladen können. Sie erhalten dann für jeden einzelnen Teilnehmer direkt den Logincode.  
Die CSV-Datei muss die folgenden Kriterien erfüllen:

 * Die CSV-Datei muss mit Komma- oder Tab-getrennt sein
 * Die Datei muss in UTF-8 (Unicode UTF-8) kodiert sein
 * Die Datei muss mindestens vier Spalten enthalten. Alle weiteren Spalten werden ignoriert:
   * der Name der Gruppe, (es können mehrere Gruppen in einer Datei definert sein)
   * die Jahrgangsstufe des Teilnehmers,
   * den Vorname des Teilnehmers und
   * den Nachname des Teilnehmers

Beispiel-CSV-Datei:
```
Gruppenname,Stufe,Vorname,Nachname  
7a,7,Gabi,Musterfrau  
7a,7,Max,Mustermann  
Info19,12,Ferdinand,Fallbeispiel
```

Dieses Beispiel legt zwei Gruppen an: `7a` und `Info19`. In der ersten Gruppe werden zwei Nutzer angelegt, in der zweiten Gruppe wird ein Nutzer angelegt.

#### Gruppe anzeigen
Gehen Sie in die `Gruppenverwaltung`. Unten auf der Seite unter `Meine verwalteten Gruppen` sehen Sie alle Ihre Gruppen. Klicken Sie auf den Namen einer Gruppe, um die Gruppe zu öffnen. Sie sehen dann alle Mitglieder der Gruppe und den Logincode der einzelnen Teilnehmerinnen und Teilnehmer. Dort haben Sie auch die Möglichkeit die Daten wie Name, Jahrgangsstufe und Geschlecht zu ändern.

#### Mitgliederliste von Gruppe herunterladen
Sie können die Mitgliederliste ihrer Gruppen als CSV-Datei herunterladen. Gehen Sie dazu in die `Gruppenverwaltung` zur Übersicht der Gruppen. In der Spalte Download finden Sie einen Link mit dem Sie die Datei herunterladen können. Oder gehen Sie in eine Ihrer Gruppen. Dort finden Sie auch den Link zum herunterladen der Datei.

### Wettbewerbsergebnisse

#### Wettbewerbsergebnisse einsehen
Klicken Sie oben rechts auf `Gruppenverwaltung`. Klicken Sie dort auf `Wettbewerbsergebnisse einsehen.` Wählen Sie dann den Wettbewerb aus, bei dem Sie die Ergebnisse Ihrer Teilnehmerinnen und Teilnehmer einsehen möchten. Sie erhalten eine Übersicht.  

Alternativ wählen Sie auf der Startseite den Wettbewerb oder die Übungsaufgabe aus, von dem Sie die Ergebnisse einsehen wollen. Klicken Sie dann auf den blauen Kasten `Gruppenergebnisse`.

#### Wettbewerbsergebnisse herunterladen
Wenn Sie in der Ergnisübersicht eines Wettbewerbs sind, finden Sie einen Link, mit dem Sie das Ergebnis als CSV-Datei herunterladen können.

### FAQ

##### Ein/e SchülerIn hat den Logincode nicht aufgeschrieben. Kann ich ihn für ihn einsehen?
Ja. Gehen Sie dazu in die `Gruppenverwaltung` und lassen Sie sich die entsprechende Gruppe anzeigen. In der Ansicht wird neben jeder Teilnemerin / jedem Teilnehmer sein Logincode angezeigt.

##### Kann ich den Teilnehmerinnen und Teilnehmern fertige Zugangsdaten auf Papier ausdrucken?
Ja. Erstellen Sie eine neue Gruppe mit allen Teilnehmerinnen und Teilnehmern per CSV-Upload (s.o.). Dabei wird für jeden Schüler ein individueller Logincode erstellt.

Wenn Sie sich dann die Mitgliederliste von Gruppe herunterladen, haben Sie eine Datei, die zu jedem Namen den Logincode auflistet. Diese können Sie nach belieben formatieren, ausdrucken und ausschneiden.

## Bedienung für Administratoren

### Einloggen
Gehen Sie auf https://jwinf.de/. Klicken Sie oben rechts auf `BWINF-Login / Lehrer-Login`. Loggen Sie sich mit Ihren BWINF-Accountdaten ein.

### Administrationsseite aufrufen
Klicken Sie oben rechts auf `Administration` oder gehen Sie direkt auf https://jwinf.de/admin.

Auf der Administrationsseite können Sie nach Benutzern und Gruppen suchen. Dafür stehen die folgenden Sucharten zur Verfügung:

1.  Suche nach Namen des Benutzers
2.  Suche nach Logincode des Benutzers
3.  Suche nach Gruppencode der Gruppe
4.  Suche nach Nutzer-ID des Benutzers
5.  Suche nach PMS-ID des Benutzers

Bei der Suche nach dem Namen des Benutzers lässt sich das Zeichen `%` als Wildcard einsetzen. Um nach allen Namen zu suchen, die auf "ter" enden, können Sie also `%ter` eingeben. Um nach allen Namen zu suchen, die ein `aus` enthalten, können Sie `%aus%` eingeben. Die Suche nach Namen ist Case-Sensitive, unterscheidet also Groß-und-kleinschreibung.

Um nach eine Gruppe zu suchen, deren Gruppencode Sie nicht kennen, können Sie entweder nach einem Teilnehmer der Gruppe suchen oder nach dem Ersteller der Gruppe. Von dort aus können Sie dann alle Gruppen sehen, die der Nutzer erstellt hat oder die Gruppe in der er Mitglied ist.

Analog können Sie auch nach einem Benutzer suchen, in dem Sie nach einem Schüler des Lehrers suchen oder andersherum nach dem Lehrer des Schülers.

Die Suche liefert maximal 30 Ergebnisse. Sollten mehr als 30 Treffer zu Ihrer Suche gefunden werden, müssen Sie Ihre Suche verfeinern.

### Benutzer anzeigen
Suchen sie nach dem Nutzer unter Angabe des Namen, des Logincode, der Nutzer-ID oder der PMS-ID des Benutzers. Wählen Sie den entsprechenden Nutzer. Alternativ ist eine Suche über die Gruppe möglich (s. o.).

Die folgenden Informationen zu Benutzern werden angezeigt:

 * die Nutzer-Id,
 * der Vor- und Nachname,
 * ggf. der Logincode
 * ggf. der Status als Lehrer,
 * ggf. die PMS-ID,
 * die Gruppe des Schülers oder alle Gruppen des Lehrers und
 * alle Wettbewerbsteilnahmen.

### Gruppe anzeigen
Suchen sie nach der Gruppe unter Angabe des Gruppencodes der Gruppe. Wählen Sie die entsprechende Gruppe. Alternativ ist eine Suche über den Gruppen-Administrator oder über Mitglieder der Gruppe möglich (s. o.).

Die folgenden Informationen zu Gruppen werden angezeigt:

 * die Guppen-Id,
 * der Gruppenname,
 * der Gruppencode,
 * der Marker,
 * der Gruppen-Administrator und
 * alle Mitglieder der Gruppe (inkl. Logincode und Jahrgangsstufe).

### Teilnahmen anzeigen
Rufen Sie den Nutzer auf, dessen Teilnahme Sie sich anzeigen lassen wollen. Wählen Sie den entsprechenden Wettbewerb aus der Liste der Teilnahmen des Nutzers aus.

Die folgenden Informationen zu Teilnahmen werden angezeigt:

 * der Nutzer,
 * der Wettbewerb,
 * der Startzeitpunkt der Teilnahme und
 * alle Einsendungen in dieser Teilnahme mit Zeitpunkt und erziehlten Punkten.

### Teilnahmen zurücksetzen (löschen)
Rufen Sie den entsprechenden Nutzer auf. Vergewissern Sie sich, dass es sich um den richtigen Nutzer handelt, eine gelöschte Teilnahme lässt sich nicht wiederherstellen. Wählen sie die entsprechende Teilnahme aus der Liste der Teilnahmen aus. Löschen Sie dann die Teilnahme indem Sie auf `Teilnahme löschen!` klicken.

### Benutzer löschen
Rufen Sie den entsprechenden Nutzer auf. Vergewissern Sie sich, dass es sich um den richtigen Nutzer handelt, ein gelöschter Nutzer lässt sich nicht wiederherstellen. Löschen Sie alle ggf. vorhandenen Teilnahmen des Nutzers (s. o.) und löschen Sie dann den Nutzer indem Sie auf `Benutzer löschen!` klicken.

### Gruppe löschen
Rufen Sie die entsprechende Gruppe auf. Vergewissern Sie sich, dass es sich um die richtige Gruppe handelt, eine gelöschte Gruppe lässt sich nicht wiederherstellen. Löschen Sie alle ggf. vorhandenen Mitglieder der Gruppe (s. o.) und löschen Sie dann die Gruppe indem Sie auf `Gruppe löschen!` klicken.

### Wettbewerbsergebnisse herunterladen
Gehen Sie auf http://jwinf.de/admin/contest/. (Alternativ die Administrationsseite aufrufen (s. o.) und ganz unten auf `Wettbewerbsübersicht` klicken.)

Mit Klick auf den entsprechenden Wettbewerb werden die Ergebnisse des Wettbewerbs zusammengestellt und heruntergeladen.

Achtung: Die Zusammenstellung der Ergebnisse nimmt viel Rechenleistung in Anspruch. Dies sollte nicht während eines laufenden Wettbewerbs und auf keinen Fall in Stoßzeiten durchgeführt werden, da das sonst zu schweren Erreichbarkeitsproblemen bei den Teilnehmern führen kann.

### Teilnahmezahlen ansehen
Unter https://jwinf.de/dbstatus können jederzeit die Teilnahmezahlen aller Wettbewerbe abgerufen werden.

Die Angaben werden nur höchstens einmal pro Minute aktualisiert.

## Troubleshooting
Wenn Fehler auftreten ist es einerseits wichtig, den Fehler so schnell wie möglich zu beheben, damit die Schüler und Lehrer ohne große Probleme am Wettbewerb teilnehmen können. Andererseits ist es aber auch wichtig, die Fehlerursache zu finden um den Fehler auch in Zukunft vermeiden zu können.

Einige Fehler, die mit schlechter Erreichbarkeit der Wettbewerbsplattform zu tun haben, lassen sich nur schwer begrenzen. Sie können am Browser des Nutzers, an der Internetverbindung oder an der Plattform selbst liegen.

Wenn der Fehler live auftritt, sollte die Seite https://jwinf.de/debug vom Benutzer aufgerufen werden. Die dort aufgeführten Zahlen und Werte erlauben es, Schlussfolgen über die Ursache schlechter Erreichbarkeit zu ziehen.

Beispiel:
```
Browser: Firefox 85

Session: existing (448374) alive

Activity: 0 ( N1615298564 - B1615298563 )

Login status: not logged in login

Session token: jwMExv1l9K reset create

Connectiviy:
Local: 122, 121, 147
Remote: 119, 120, 143
```

Mögliche Interpretation der Angaben sind:

 - Browser: 
   - Browsername und Version
   - Zur Teilnahmen sind mindestens notwendig: 
     - Firefox 46
     - Chrome 50
     - Safari 10
     - Edge 15
     - Die Mindestversionen können im Laufe der Zeit steigen.
 - Session: 
   - "not existing": Person hat möglicherweise Cookies deaktiviert. Cookies sind für die Benutzung der Seite notwendig.
   - "existing (…) alive": gut
   - nicht alive: Session ist abgelaufen. Browserneustart oder neu einloggen sollte helfen.
 - Activity:
   - Zeit seit letztem Seitenaufruf in Sekunden
 - Login status:
   - Ist Nutzer eingeloggt oder nicht 
     - "logged in as" gibt an:
       - Benutzername
       - Voller Name (in Klammern)
       - "[Lehrer]" falls Lehrerstatus gesetzt
       - OAuth-ID gibt PMS-ID an, falls sich Benutzer über das PMS eingeloggt hat
 - Session token: 
   - Im Cookie gespeicherter Wert (technisches Detail)
 - Connectiviy:
   - Gibt an wie gut die Verbindung zum Server ist. Niedrige Werte sind besser (schneller)
     - Am besten ein paar mal neuladen, um zu sehen, wie die Zahlen schwanken.
     - Gute Zahlen sind kleiner als 200, in manchen Fällen bis zu 400.
     - Sind die Zahlen mehrfach größer als 500 ist das ein Problem, Teilnahme könnte schwierig werden.
   - Ist "local" viel großer als "remote" liegt ein Problem mit dem Server vor. Bitte sofort einen Admin benachrichtigen.
   - Ist die dritte Zahl viel großer als die erste, ist die Geschwindigkeit der Verbindung langsam.
     - Ist das sowohl bei "local" als auch bei "remote" der Fall, deutet das auf ein Problem auf der Nutzerseite hin.
   - Sind alle Zahlen gleichmäßig hoch, ist die Latenz der Verbindung langsam.
     - Ist das sowohl bei "local" als auch bei "remote" der Fall, deutet das auf ein Problem auf der Nutzerseite hin.
