use structopt::StructOpt;
use anyhow::{Context, Result};

#[derive(StructOpt, Debug)]
struct Cli {
    pattern: String,
    #[structopt(parse(from_os_str))]
    path: std::path::PathBuf,
}

fn main() -> Result<()> {
    let args: Cli = Cli::from_args();
    let content = std::fs::read_to_string(&args.path)
        .with_context(|| format!("failed to read file: {}", &args.path.display()))?;

    meck_grrs::find_matches(&content, &args.pattern, &mut std::io::stdout());

    Ok(())
}
