use std::env;
use std::path::Path;
use clap::{Parser, Subcommand};
use mdup::generator::{generate, GenerateArgs};

#[derive(Parser, Debug)]
#[clap(version, about)]
struct Args {
    #[clap(subcommand)]
    command: Commands,
}

#[derive(Subcommand, Debug)]
enum Commands {
    /// Build doc site
    Build {
        dir: Option<String>,
        #[clap(short, long)]
        output: Option<String>,
    },
}

fn main() {
    env_logger::init();

    let args: Args = Args::parse();

    match args.command {
        Commands::Build { dir, output } => {
            let current_dir = env::current_dir().unwrap();
            let dir = match dir {
                Some(dir) => { dir }
                None => { current_dir.to_str().unwrap().to_string() }
            };
            let output = match output {
                Some(output) => { output }
                None => { Path::new(&dir).join("dist").to_str().unwrap().to_string() }
            };
            let generate_args = GenerateArgs {
                dir,
                output,
            };
            generate(&generate_args).expect("Generate failed");
        }
    }
}
