<!-- 本文件由 ./readme.make.md 自动生成，请不要直接修改此文件 -->

# mdbx

rust wrapper for [libmdbx](https://github.com/erthink/libmdbx)

## use example

```
#![allow(non_upper_case_globals)]
use anyhow::Result;
use lazy_static::lazy_static;
use mdbx::{db, env::Env, Db};

lazy_static! {
    pub static ref MDBX: Env = {
        let mut dir = std::env::current_exe().unwrap();
        dir.pop();
        dir.push("test");
        println!("mdbx file path {}", dir.display());
        dir.try_into().unwrap()
    };
}

Db!(MDBX, UserName);

// [mdbx db flag list link](https://erthink.github.io/libmdbx/group__c__dbi.html#gafe3bddb297b3ab0d828a487c5726f76a)
Db!(MDBX, Tag, db::Flag::MDBX_DUPSORT);

fn main() -> Result<()> {
    unsafe {
        println!(
            "mdbx version https://github.com/erthink/libmdbx/releases/tag/v{}.{}.{}",
            mdbx::mdbx_version.major,
            mdbx::mdbx_version.minor,
            mdbx::mdbx_version.release
        );
    }
    let t = std::thread::spawn(|| {
        let tx = &MDBX.w()?;
        let user_name = UserName & tx;
        user_name.set(&[3], &[4])?;
        dbg!("thread", user_name.get(&[2])?);
        dbg!("thread", user_name.get(&[3])?);
        Ok::<(), anyhow::Error>(())
    });

    {
        let tx = &MDBX.w()?;
        let user_name = UserName & tx;
        user_name.set(&[2], &[5])?;
        dbg!("main", user_name.get(&[2])?);
        dbg!("main", user_name.get(&[3])?);
        let tag = Tag & tx;
        tag.set(&[1], &[2])?;
        tag.set(&[1], &[3])?;
        dbg!(tag.get(&[1])?);
    }

    t.join().unwrap()?;

    Ok(())
}
```

output as below

```
mdbx file path /root/git/mdbx/target/debug/examples/test
mdbx version https://github.com/erthink/libmdbx/releases/tag/v0.11.1
```

## 关于

本项目隶属于**人民网络([rmw.link](//rmw.link))** 代码计划。

![人民网络](https://raw.githubusercontent.com/rmw-link/logo/master/rmw.red.bg.svg)