use std::{io, io::prelude::*};
use regex::Regex;
use emojis;

pub fn main() {
    for line in io::stdin().lock().lines() {
        let l = &line.as_ref().unwrap();
        let re = Regex::new(r":[a-zA-Z_]*:").unwrap();
        if re.is_match(&l) {
            let mut edited: String = String::new();
            edited.push_str(&l);
            for cap in re.captures_iter(&l) {
                let shortcode = cap[0].to_string();
                let emoji = emojis::lookup(&shortcode.replace(":",""));
                if emoji != None {
                    let emoji = emoji.unwrap().to_string();
                    let r = Regex::new(&shortcode).unwrap();
                    edited = r.replace_all(&edited, &emoji).to_string();
                }
            }
            println!("{}", &edited);
        } else {
            println!("{}", l);
        };
    };
}
