use rkyv::{Archive, Deserialize, Serialize};
use std::fmt::Debug;

#[derive(Debug, Archive, Serialize, Deserialize, Clone, PartialEq, Default)]
pub struct Quote {
    pub size: u64,
    pub ask_price: f64,
    pub bid_price: f64,
}

#[derive(Debug, Archive, Serialize, Deserialize, Clone, PartialEq, Default)]
pub struct Trade {
    pub size: u64,
    pub price: f64,
}

pub trait Tick: Clone + Debug + Archive {
    const BYTE_SIZE: usize;

    fn epoch(&self, time: u64) -> u64;
}

impl Tick for Quote {
    const BYTE_SIZE: usize = 24;

    fn epoch(&self, time: u64) -> u64 {
        time / 86_400_000_000_000 // 1 day
    }
}

impl Tick for Trade {
    const BYTE_SIZE: usize = 16;

    fn epoch(&self, time: u64) -> u64 {
        time / 86_400_000_000_000 // 1 day
    }
}
