use mdb::Magma;

#[derive(rkyv::Archive, rkyv::Deserialize, rkyv::Serialize, Clone, Debug, Default)]
struct Trade {
    time: u64,
    size: u32,
    price: u32,
}

impl mdb::Tick for Trade {
    const BYTE_SIZE: usize = 16;

    fn epoch(&self, time: u64) -> u64 {
        // one day
        time / 86_400_000_000_000
    }
}

#[tokio::main]
async fn main() -> Result<(), mdb::Error> {
    let trade1 = Trade {
        time: 10,
        size: 1,
        price: 2,
    };

    let trade2 = Trade {
        time: 11,
        size: 2,
        price: 3,
    };

    let trade3 = Trade {
        time: 12,
        size: 3,
        price: 4,
    };

    let mut mdb = Magma::<Trade>::new("BTC", "./testdb")?;

    mdb.insert(&mdb::Frame::new(trade1.time, trade1))?;
    mdb.insert(&mdb::Frame::new(trade2.time, trade2))?;
    mdb.insert(&mdb::Frame::new(trade3.time, trade3))?;

    mdb.persist()?;

    mdb.epochs().for_each(|mut epoch| {
        epoch.frames().for_each(|frame| {
            println!("{:?}", frame.time());
        });
    });

    Ok(())
}
