//! Magam Timeseries Datastore

/// Datastore Folder Layout Handler
pub mod path_builder;

/// An Entry in the datastore
pub mod tick;
pub use tick::Tick;

/// Radix Tree Index
pub mod index;

pub mod frame;
pub use frame::Frame;

mod data_file;
pub use data_file::DataFile;

pub mod epoch;
pub use epoch::Epoch;

mod error;
pub use error::{Error, Result};

mod db;
pub use db::Magma;
