//! Crate Error Type

use thiserror::Error;

#[derive(Error, Debug)]
pub enum Error {
    #[error("Ser/Der Error")]
    Bincode,

    #[error("IO Error")]
    IoError(#[from] std::io::Error),
    #[error("Inflate Error")]
    InflateError(miniz_oxide::inflate::TINFLStatus),
    #[error("Bad Data found")]
    BadData,

    #[error("Inconsistency")]
    Inconsistency,

    #[error("Index File Failure")]
    IndexFileFailure,
    #[error("Write Failure")]
    WriteFailure,
    #[error("Frame Conflict")]
    FrameConflict,
    #[error("Frame Too Big")]
    FrameTooBig,
    #[error("Frame Empty")]
    FrameEmpty,

    #[error("Bad Frame Epoch")]
    BadFrameEpoch,
    #[error("Bad Frame Tick")]
    BadFrameTick,

    #[error("File is Empty")]
    DataFileEmpty,

    #[error("could not deserialize using rkyv")]
    RkyvDeserializer,
}

pub type Result<T> = std::result::Result<T, Error>;
