use proc_macro::TokenStream;
use strfn::strfn;

#[proc_macro] pub fn
semicolon_1(input: TokenStream) -> TokenStream {
    let res = input.to_string();
    let last = res.chars().collect::<Vec<char>>()[res.len()-1];

    if last == ';' {
        return res.parse().unwrap();
    } else {
        return (res+";").parse().unwrap();
    }
}

#[proc_macro] pub fn
m(input: TokenStream) -> TokenStream {
    let mut text = String::from("");

    for slice in strfn(input.to_string()).iter() {
        if !slice.1 {
            text += &(slice.0.replace("{", "{semicolon::semicolon_2!{").replace("}", "}}"))[..];
        } else { text += &(slice.0)[..] }
    }
    ("{semicolon::semicolon_2!{".to_owned() + &text[..] + "}}").parse().unwrap()
}
