pub use std::sync::{Arc, Mutex};

pub use lapin::Channel;
pub use log::{debug, error, info, trace, warn};
pub use schemars::JsonSchema;
pub use semver::Version;

#[cfg(feature = "media")]
pub use {
  crate::process_result::ProcessResult,
  stainless_ffmpeg::prelude::*,
  stainless_ffmpeg::{format_context::FormatContext, frame::Frame},
};

#[cfg(feature = "media")]
pub use crate::media::process_frame::ProcessFrame;
#[cfg(feature = "media")]
pub use crate::media::{
  audio::AudioFormat,
  ebu_ttml_live::*,
  filters::{AudioFilter, GenericFilter, VideoFilter},
  json::*,
  subrip::*,
  video::{RegionOfInterest, Scaling, VideoFormat},
  webvtt::*,
  StreamDescriptor,
};
pub use crate::{
  job::{Job, JobProgression, JobResult, JobStatus},
  message_exchange::{
    message::{Feedback, OrderMessage, ResponseMessage},
    rabbitmq::*,
    ExternalExchange, LocalExchange, RabbitmqExchange,
  },
  parameter::{MediaSegment, MediaSegments, Parameter, ParameterValue, Requirement},
  processor::{ProcessStatus, Processor},
  publish_job_progression,
  start_worker::start_worker,
  worker::{
    SystemInformation, WorkerActivity, WorkerConfiguration, WorkerParameter, WorkerParameterType,
    WorkerStatus,
  },
  McaiChannel, McaiWorker, MessageError, ParametersContainer, Result,
};
