#[cfg(any(feature = "functional_testing", feature = "processor_testing"))]
#[macro_use]
extern crate serde_derive;
#[cfg(feature = "media")]
extern crate stainless_ffmpeg;

#[cfg(feature = "local_processor_testing")]
mod local_processor {
  mod simple {
    mod local_init_job_error;
    mod local_init_start_processor;
    mod local_job_processor;
    mod local_stop_job;
  }
}

#[cfg(feature = "rabbitmq_processor_testing")]
mod rabbitmq_processor {
  mod simple {
    mod rabbitmq_stop_job;
    mod rabbitmq_ttl_job;
  }
}

#[cfg(feature = "media")]
mod generator {
  pub mod ffmpeg;
  // pub mod srt_stream;
}

#[cfg(feature = "media")]
mod media {
  use super::generator::ffmpeg;
  mod seek;
}

#[cfg(feature = "rabbitmq_testing")]
mod client;

#[cfg(feature = "media_local_processor_testing")]
mod local_processor {
  use super::generator::ffmpeg;
  mod media {
    use super::*;

    mod local_complete_job;
    mod local_init_job_error;
  }
}

#[cfg(feature = "media_rabbitmq_processor_testing")]
mod rabbitmq_processor {
  use super::generator::ffmpeg;
  mod media {
    use super::*;

    mod rabbitmq_stop_job;
    mod rabbitmq_ttl_job;
    mod rabbitmq_update_job;
  }
}

#[cfg(feature = "functional_testing")]
mod functional {
  #[cfg(not(feature = "media"))]
  mod vault_credentials_test;
}
