use super::{SystemInformation, WorkerActivity, WorkerConfiguration};
use crate::worker::configuration::WorkerDescription;

/// Container to generate the status message for the worker
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WorkerStatus {
  #[serde(flatten)]
  pub worker_description: WorkerDescription,
  pub activity: WorkerActivity,
  pub system_info: SystemInformation,
}

impl WorkerStatus {
  pub fn new(activity: WorkerActivity, worker_configuration: WorkerConfiguration) -> Self {
    let system_info = SystemInformation::new(&worker_configuration);
    WorkerStatus {
      worker_description: worker_configuration.get_worker_description(),
      activity,
      system_info,
    }
  }
}
